package org.drools.cep;

import java.util.*;
import org.drools.model.*;
import org.drools.modelcompiler.dsl.pattern.D;
import org.drools.model.Index.ConstraintType;
import java.time.*;
import java.time.format.*;
import java.text.*;
import org.drools.core.util.*;
import org.kie.hacep.sample.kjar.StockTickEvent;
import java.util.UUID;
import org.kie.remote.DroolsExecutor;
import org.kie.hacep.sample.kjar.Result;
import org.drools.model.Model;
import org.drools.model.Query;

public class Rules1AEE7B9A9EAB020D98EC2850EE4B57A1 implements Model {

    public final static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.getDateFormatMask(),
                                                                                            Locale.ENGLISH);

    @Override
    public String getName() {
        return "org.drools.cep";
    }

    public static Date string_2_date(String s) {
        return GregorianCalendar.from(LocalDate.parse(s,
                                                      DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault()))
                                .getTime();
    }

    @Override
    public List<org.drools.model.EntryPoint> getEntryPoints() {
        return Collections.emptyList();
    }

    @Override
    public List<org.drools.model.Global> getGlobals() {
        return globals;
    }

    @Override
    public List<org.drools.model.TypeMetaData> getTypeMetaDatas() {
        return typeMetaDatas;
    }

    public static final org.drools.model.Query1Def<java.lang.String> queryDef_stockTickEventQuery = D.query("org.drools.cep",
                                                                                                            "stockTickEventQuery",
                                                                                                            java.lang.String.class,
                                                                                                            "companyName");

    List<org.drools.model.Global> globals = Collections.emptyList();

    List<org.drools.model.TypeMetaData> typeMetaDatas = Collections.emptyList();

    /**
     * With the following expression ID:
     * org.drools.modelcompiler.builder.generator.DRLIdGenerator@6bdc984
     */
    @Override
    public List<org.drools.model.Rule> getRules() {
        return rules;
    }

    public List<Rule> getRulesList() {
        return Arrays.asList(Rules1AEE7B9A9EAB020D98EC2850EE4B57A1RuleMethods0.rule_StockAverage(),
                             Rules1AEE7B9A9EAB020D98EC2850EE4B57A1RuleMethods0.rule_StockLog());
    }

    List<org.drools.model.Rule> rules = getRulesList();

    final Query query_stockTickEventQuery = query_stockTickEventQuery();

    @Override
    public List<org.drools.model.Query> getQueries() {
        return queries;
    }

    private org.drools.model.Query query_stockTickEventQuery() {
        final org.drools.model.Variable<org.kie.hacep.sample.kjar.StockTickEvent> var_stock = D.declarationOf(org.kie.hacep.sample.kjar.StockTickEvent.class,
                                                                                                              DomainClassesMetadata1AEE7B9A9EAB020D98EC2850EE4B57A1.org_kie_hacep_sample_kjar_StockTickEvent_Metadata_INSTANCE,
                                                                                                              "stock");
        org.drools.model.Query stockTickEventQuery_build = queryDef_stockTickEventQuery.build(D.pattern(var_stock).expr("0A137729CEB27E8D42587217F18E1BCF",
                                                                                                                        queryDef_stockTickEventQuery.getArg1(),
                                                                                                                        (_this, companyName) -> org.drools.modelcompiler.util.EvaluationUtil.areNullSafeEquals(_this.getCompany(),
                                                                                                                                                                                                               companyName),
                                                                                                                        D.betaIndexedBy(java.lang.String.class,
                                                                                                                                        org.drools.model.Index.ConstraintType.EQUAL,
                                                                                                                                        DomainClassesMetadata1AEE7B9A9EAB020D98EC2850EE4B57A1.org_kie_hacep_sample_kjar_StockTickEvent_Metadata_INSTANCE.getPropertyIndex("company"),
                                                                                                                                        (org.kie.hacep.sample.kjar.StockTickEvent _this) -> _this.getCompany(),
                                                                                                                                        (java.lang.String companyName) -> companyName),
                                                                                                                        D.reactOn("company")));
        return stockTickEventQuery_build;
    }

    List<org.drools.model.Query> queries = new ArrayList<>();

    {
        queries.add(query_stockTickEventQuery);
    }
}
