/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieServerConfigItem;

@XmlRootElement(name="kie-server-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class KieServerConfig {
    @XmlElement(name="config-items")
    @XStreamImplicit
    private List<KieServerConfigItem> configItems = new ArrayList<KieServerConfigItem>();

    public KieServerConfig() {
    }

    public KieServerConfig(List<KieServerConfigItem> configItems) {
        this.configItems = configItems;
    }

    public List<KieServerConfigItem> getConfigItems() {
        return this.configItems;
    }

    public void setConfigItems(List<KieServerConfigItem> configItems) {
        this.configItems = configItems;
    }

    public void addConfigItem(KieServerConfigItem configItem) {
        KieServerConfigItem existing = this.getConfigItem(configItem.getName());
        if (existing != null) {
            this.removeConfigItem(existing);
        }
        this.configItems.add(configItem);
    }

    public void removeConfigItem(KieServerConfigItem configItem) {
        this.configItems.remove(configItem);
    }

    public KieServerConfigItem getConfigItem(String name) {
        KieServerConfigItem configItem = null;
        for (KieServerConfigItem item : this.configItems) {
            if (!name.equals(item.getName())) continue;
            configItem = item;
            break;
        }
        return configItem;
    }

    public String getConfigItemValue(String name) {
        KieServerConfigItem item = this.getConfigItem(name);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public String getConfigItemValue(String name, String defaultValue) {
        KieServerConfigItem item = this.getConfigItem(name);
        if (item != null) {
            return item.getValue();
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KieServerConfig that = (KieServerConfig)o;
        return !(this.configItems != null ? !this.configItems.equals(that.configItems) : that.configItems != null);
    }

    public int hashCode() {
        return this.configItems != null ? this.configItems.hashCode() : 0;
    }

    public String toString() {
        return "KieServerConfig{configItems=" + this.configItems + '}';
    }
}

