/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.AnotherMessage;
import org.kie.server.api.marshalling.objects.Message;
import org.kie.server.api.model.KieContainerResourceFilter;

public class XstreamMarshallerTest {
    @Test
    public void testXstreamMarshalWithAnnotation() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.Message>\n  <nameWithAlias>test content</nameWithAlias>\n</org.kie.server.api.marshalling.objects.Message>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        Message testMessage = new Message("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testXstreamMarshalWithCustomMarshallerBuilder() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.AnotherMessage>\n  <another_name>test content</another_name>\n</org.kie.server.api.marshalling.objects.AnotherMessage>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        AnotherMessage testMessage = new AnotherMessage("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testUnmarshallListContainersCommandWithNoFilter() {
        String commandString = "<list-containers/>";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        ListContainersCommand command = (ListContainersCommand)marshaller.unmarshall(commandString, ListContainersCommand.class);
        Assertions.assertThat((Object)command.getKieContainerResourceFilter()).isEqualTo((Object)KieContainerResourceFilter.ACCEPT_ALL);
    }
}

