/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.server.api.model.dmn.DMNMessageKS;
import org.kie.server.api.model.dmn.DMNResultKS;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dmn-decision-result")
public class DMNDecisionResultKS
implements DMNDecisionResult {
    @XmlElement(name="decision-id")
    private String decisionId;
    @XmlElement(name="decision-name")
    private String decisionName;
    @XmlElement(name="result")
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object result;
    @XmlElementWrapper(name="messages")
    private List<DMNMessageKS> messages;
    @XmlElement(name="status")
    private DMNDecisionResult.DecisionEvaluationStatus status;

    public static DMNDecisionResultKS of(DMNDecisionResult value) {
        DMNDecisionResultKS res = new DMNDecisionResultKS();
        res.decisionId = value.getDecisionId();
        res.decisionName = value.getDecisionName();
        res.setResult(value.getResult());
        res.setMessages(value.getMessages());
        res.status = value.getEvaluationStatus();
        return res;
    }

    public String getDecisionId() {
        return this.decisionId;
    }

    public void setDecisionId(String decisionId) {
        this.decisionId = decisionId;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public void setDecisionName(String decisionName) {
        this.decisionName = decisionName;
    }

    public DMNDecisionResult.DecisionEvaluationStatus getEvaluationStatus() {
        return this.status;
    }

    public void setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus status) {
        this.status = status;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = DMNResultKS.stubDMNResult(result);
    }

    public List<DMNMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<DMNMessage> messages) {
        for (DMNMessage m : messages) {
            this.messages.add(DMNMessageKS.of(m));
        }
    }

    public boolean hasErrors() {
        return this.messages != null && this.messages.stream().anyMatch(m -> m.getSeverity() == DMNMessage.Severity.ERROR);
    }
}

