/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.Set;
import org.kie.server.api.marshalling.BaseMarshallerBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.xstream.XStreamMarshaller;
import org.kie.soup.commons.xstream.XStreamUtils;

public class CustomXstreamMarshallerBuilder
extends BaseMarshallerBuilder {
    public Marshaller build(Set<Class<?>> classes, MarshallingFormat format, ClassLoader classLoader) {
        if (format.equals((Object)MarshallingFormat.XSTREAM)) {
            return new XStreamMarshaller(classes, classLoader){

                protected void buildMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
                    this.xstream = XStreamUtils.createNonTrustingXStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("_-", "_")));
                    this.xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"org.kie.server.api.**"}));
                    String[] voidDeny = new String[]{"void.class", "Void.class"};
                    this.xstream.denyTypes(voidDeny);
                }
            };
        }
        return super.build(classes, format, classLoader);
    }
}

