/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;

@XmlRootElement(name="kie-container")
@XStreamAlias(value="kie-container")
public class KieContainerResource {
    @XStreamAlias(value="container-id")
    private String containerId;
    @XStreamAlias(value="release-id")
    private ReleaseId releaseId;
    @XStreamAlias(value="resolved-release-id")
    private ReleaseId resolvedReleaseId;
    @XStreamAlias(value="status")
    private KieContainerStatus status;
    @XStreamAlias(value="scanner")
    private KieScannerResource scanner;
    @XStreamImplicit
    private List<KieServerConfigItem> configItems = new ArrayList<KieServerConfigItem>();
    @XStreamImplicit
    private List<Message> messages = new ArrayList<Message>();
    @XStreamAlias(value="container-alias")
    private String containerAlias;

    public KieContainerResource() {
    }

    public KieContainerResource(ReleaseId releaseId) {
        this(null, releaseId, null, null);
    }

    public KieContainerResource(String containerId, ReleaseId releaseId) {
        this(containerId, releaseId, null, null);
    }

    public KieContainerResource(String containerId, ReleaseId releaseId, KieContainerStatus status) {
        this(containerId, releaseId, null, status);
    }

    public KieContainerResource(String containerId, ReleaseId releaseId, ReleaseId resolvedReleaseId, KieContainerStatus status) {
        this.containerId = containerId;
        this.releaseId = releaseId;
        this.resolvedReleaseId = resolvedReleaseId;
        this.status = status;
    }

    @XmlAttribute(name="container-id")
    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @XmlAttribute(name="status")
    public KieContainerStatus getStatus() {
        return this.status;
    }

    public void setStatus(KieContainerStatus status) {
        this.status = status;
    }

    @XmlElement(name="release-id")
    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    @XmlElement(name="resolved-release-id")
    public ReleaseId getResolvedReleaseId() {
        return this.resolvedReleaseId;
    }

    public void setResolvedReleaseId(ReleaseId resolvedReleaseId) {
        this.resolvedReleaseId = resolvedReleaseId;
    }

    @XmlElement
    public KieScannerResource getScanner() {
        return this.scanner;
    }

    public void setScanner(KieScannerResource scanner) {
        this.scanner = scanner;
    }

    @XmlElement(name="config-items")
    public List<KieServerConfigItem> getConfigItems() {
        return this.configItems;
    }

    public void setConfigItems(List<KieServerConfigItem> configItems) {
        this.configItems = configItems;
    }

    public void addConfigItem(KieServerConfigItem configItem) {
        this.configItems.add(configItem);
    }

    @XmlElement(name="messages")
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    @XmlAttribute(name="container-alias")
    public String getContainerAlias() {
        return this.containerAlias;
    }

    public void setContainerAlias(String containerAlias) {
        this.containerAlias = containerAlias;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerId == null ? 0 : this.containerId.hashCode());
        result = 31 * result + (this.releaseId == null ? 0 : this.releaseId.hashCode());
        result = 31 * result + (this.resolvedReleaseId == null ? 0 : this.resolvedReleaseId.hashCode());
        result = 31 * result + (this.containerAlias == null ? 0 : this.containerAlias.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KieContainerResource other = (KieContainerResource)obj;
        if (this.containerId == null ? other.containerId != null : !this.containerId.equals(other.containerId)) {
            return false;
        }
        if (this.releaseId == null ? other.releaseId != null : !this.releaseId.equals(other.releaseId)) {
            return false;
        }
        if (this.resolvedReleaseId == null ? other.resolvedReleaseId != null : !this.resolvedReleaseId.equals(other.resolvedReleaseId)) {
            return false;
        }
        return !(this.containerAlias == null ? other.containerAlias != null : !this.containerAlias.equals(other.containerAlias));
    }

    public String toString() {
        return "KieContainerResource [containerId=" + this.containerId + ", releaseId=" + this.releaseId + ", resolvedReleaseId=" + this.resolvedReleaseId + ", status=" + (Object)((Object)this.status) + "]";
    }
}

