/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.objects.DateObject;

public class JSONMarshallerTest {
    @After
    public void cleanup() {
        System.clearProperty("org.kie.server.json.format.date");
    }

    @Test
    public void testMarshallDateObject() {
        String expectedString = String.format("{%n  \"localDate\" : \"2017-01-01\",%n  \"localDateTime\" : \"2017-01-01T10:10:10\",%n  \"localTime\" : \"10:10:10\",%n  \"offsetDateTime\" : \"2017-01-01T10:10:10+01:00\"%n}", new Object[0]);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = new DateObject();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObject() {
        String expectedString = "{\n  \"localDate\" : \"2017-01-01\",\n  \"localDateTime\" : \"2017-01-01T10:10:10\",\n  \"localTime\" : \"10:10:10\",\n  \"offsetDateTime\" : \"2017-01-01T10:10:10+01:00\"\n}";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }

    @Test
    public void testRecursiveMap() {
        HashMap outerMap = new HashMap();
        HashMap<String, Holder> innerMap = new HashMap<String, Holder>();
        Holder holder = new Holder();
        holder.setH("myValueInH");
        innerMap.put("level2", holder);
        outerMap.put("level1", innerMap);
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        Map mu_outerMap = (Map)marshaller.unmarshall(marshaller.marshall(outerMap), Map.class);
        Map mu_innerMap = (Map)marshaller.unmarshall(marshaller.marshall(innerMap), Map.class);
        Ref ref = new Ref();
        ref.setR(innerMap);
        Ref mu_ref = (Ref)marshaller.unmarshall(marshaller.marshall((Object)ref), Ref.class);
        Assert.assertEquals((String)"verify that Ref.r is not being serialized with JSONMarshaller.WrappingObjectSerializer, but with the specified one in @JsonSerialize", mu_innerMap.entrySet(), ((Map)mu_ref.getR()).entrySet());
    }

    @Test
    public void testMarshallFormatDateObject() throws ParseException {
        System.setProperty("org.kie.server.json.format.date", "true");
        Date date = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ").parse("2018-01-01T10:00:00.000+0100");
        String expectedString = "\"2018-01-01";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        String dateObjectString = marshaller.marshall((Object)date);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertTrue((boolean)dateObjectString.startsWith(expectedString));
    }

    public static class Ref {
        @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
        @JsonSerialize(using=JSONMarshaller.PassThruSerializer.class)
        private Object r;

        public Object getR() {
            return this.r;
        }

        public void setR(Object r) {
            this.r = r;
        }
    }

    public static class Holder {
        private String h;

        public String getH() {
            return this.h;
        }

        public void setH(String h) {
            this.h = h;
        }
    }
}

