/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json.extension;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.json.JSONMarshallerExtension;

public class JSONMarshallerExtensionGregorianCalendar
implements JSONMarshallerExtension {
    private static final GregorianCalendarDeser DESERIALIZER = new GregorianCalendarDeser();
    private static final GregorianCalendarSer SERIALIZER = new GregorianCalendarSer();
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public void extend(JSONMarshaller marshaller, ObjectMapper serializer, ObjectMapper deserializer) {
        this.registerModule(serializer);
        this.registerModule(deserializer);
    }

    private void registerModule(ObjectMapper objectMapper) {
        SimpleModule gregorianCalendarModule = new SimpleModule("gregoriancalendar-module", Version.unknownVersion());
        gregorianCalendarModule.addDeserializer(GregorianCalendar.class, (JsonDeserializer)DESERIALIZER);
        gregorianCalendarModule.addSerializer(GregorianCalendar.class, (JsonSerializer)SERIALIZER);
        objectMapper.registerModule((Module)gregorianCalendarModule);
    }

    private static class GregorianCalendarSer
    extends JsonSerializer<GregorianCalendar> {
        private GregorianCalendarSer() {
        }

        public void serialize(GregorianCalendar value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String formattedValue = FORMATTER.format(value.getTime());
            jgen.writeString(formattedValue);
        }
    }

    private static class GregorianCalendarDeser
    extends JsonDeserializer<GregorianCalendar> {
        private GregorianCalendarDeser() {
        }

        public GregorianCalendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            try {
                String text = jp.getText();
                Date date = FORMATTER.parse(text);
                gregorianCalendar.setTime(date);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
            return gregorianCalendar;
        }
    }
}

