/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="work-item-instance")
public class WorkItemInstance {
    @XmlElement(name="work-item-id")
    private Long id;
    @XmlElement(name="work-item-name")
    private String name;
    @XmlElement(name="work-item-state")
    private Integer state = 0;
    @XmlElement(name="work-item-params")
    private Map<String, Object> parameters;
    @XmlElement(name="process-instance-id")
    private Long processInstanceId;
    @XmlElement(name="container-id")
    private String containerId;
    @XmlElement(name="node-instance-id")
    private Long nodeInstanceId;
    @XmlElement(name="node-id")
    private Long nodeId;

    public static Builder builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public Long getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(Long nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public String toString() {
        return "WorkItemInstance{id=" + this.id + ", name='" + this.name + '\'' + ", state=" + this.state + ", parameters=" + this.parameters + ", processInstanceId=" + this.processInstanceId + ", containerId='" + this.containerId + '\'' + ", nodeInstanceId=" + this.nodeInstanceId + ", nodeId=" + this.nodeId + '}';
    }

    public static class Builder {
        private WorkItemInstance workItemInstance = new WorkItemInstance();

        public WorkItemInstance build() {
            return this.workItemInstance;
        }

        public Builder id(Long id) {
            this.workItemInstance.setId(id);
            return this;
        }

        public Builder processInstanceId(Long processInstanceId) {
            this.workItemInstance.setProcessInstanceId(processInstanceId);
            return this;
        }

        public Builder nodeInstanceId(Long nodeInstanceId) {
            this.workItemInstance.setNodeInstanceId(nodeInstanceId);
            return this;
        }

        public Builder nodeId(Long nodeId) {
            this.workItemInstance.setNodeId(nodeId);
            return this;
        }

        public Builder name(String name) {
            this.workItemInstance.setName(name);
            return this;
        }

        public Builder containerId(String containerId) {
            this.workItemInstance.setContainerId(containerId);
            return this;
        }

        public Builder state(Integer state) {
            this.workItemInstance.setState(state);
            return this;
        }

        public Builder parameters(Map<String, Object> parameters) {
            this.workItemInstance.setParameters(parameters);
            return this;
        }
    }
}

