/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.util.QueryParamFactory;

public class QueryFilterSpecBuilder {
    private List<QueryParam> parameters = new ArrayList<QueryParam>();
    private QueryFilterSpec filterSpec = new QueryFilterSpec();
    private Map<String, String> columnMapping = new HashMap<String, String>();

    public QueryFilterSpec get() {
        if (!this.parameters.isEmpty()) {
            this.filterSpec.setParameters(this.parameters.toArray(new QueryParam[this.parameters.size()]));
        }
        if (!this.columnMapping.isEmpty()) {
            this.filterSpec.setColumnMapping(this.columnMapping);
        }
        return this.filterSpec;
    }

    public QueryFilterSpecBuilder oderBy(String column, boolean isAscending) {
        this.filterSpec.setOrderBy(column);
        this.filterSpec.setAscending(isAscending);
        return this;
    }

    public QueryFilterSpecBuilder addColumnMapping(String column, String type) {
        this.columnMapping.put(column, type);
        return this;
    }

    public QueryFilterSpecBuilder where(QueryParam param) {
        this.parameters.add(param);
        return this;
    }

    public QueryFilterSpecBuilder isNull(String column) {
        this.parameters.add(QueryParamFactory.isNull(column));
        return this;
    }

    public QueryFilterSpecBuilder isNotNull(String column) {
        this.parameters.add(QueryParamFactory.isNotNull(column));
        return this;
    }

    public QueryFilterSpecBuilder equalsTo(String column, Comparable<?> ... values) {
        this.parameters.add(QueryParamFactory.equalsTo(column, values));
        return this;
    }

    public QueryFilterSpecBuilder notEqualsTo(String column, Comparable<?> ... values) {
        this.parameters.add(QueryParamFactory.notEqualsTo(column, values));
        return this;
    }

    public QueryFilterSpecBuilder likeTo(String column, boolean caseSensitive, Comparable<?> value) {
        this.parameters.add(QueryParamFactory.likeTo(column, caseSensitive, value));
        return this;
    }

    public QueryFilterSpecBuilder greaterThan(String column, Comparable<?> value) {
        this.parameters.add(QueryParamFactory.greaterThan(column, value));
        return this;
    }

    public QueryFilterSpecBuilder greaterOrEqualTo(String column, Comparable<?> value) {
        this.parameters.add(QueryParamFactory.greaterOrEqualsTo(column, value));
        return this;
    }

    public QueryFilterSpecBuilder lowerThan(String column, Comparable<?> value) {
        this.parameters.add(QueryParamFactory.lowerThan(column, value));
        return this;
    }

    public QueryFilterSpecBuilder lowerOrEqualTo(String column, Comparable<?> value) {
        this.parameters.add(QueryParamFactory.lowerOrEqualsTo(column, value));
        return this;
    }

    public QueryFilterSpecBuilder between(String column, Comparable<?> start, Comparable<?> end) {
        this.parameters.add(QueryParamFactory.between(column, start, end));
        return this;
    }

    public QueryFilterSpecBuilder in(String column, List<?> values) {
        this.parameters.add(QueryParamFactory.in(column, values));
        return this;
    }

    public QueryFilterSpecBuilder notIn(String column, List<?> values) {
        this.parameters.add(QueryParamFactory.notIn(column, values));
        return this;
    }
}

