/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="node-instance")
public class NodeInstance {
    @XmlElement(name="node-instance-id")
    private Long id;
    @XmlElement(name="node-name")
    private String name;
    @XmlElement(name="process-instance-id")
    private Long processInstanceId;
    @XmlElement(name="work-item-id")
    private Long workItemId;
    @XmlElement(name="container-id")
    private String containerId;
    @XmlElement(name="start-date")
    private Date date;
    @XmlElement(name="node-id")
    private String nodeId;
    @XmlElement(name="node-type")
    private String nodeType;
    @XmlElement(name="node-connection")
    private String connection;
    @XmlElement(name="node-completed")
    private Boolean completed;
    @XmlElement(name="reference-id")
    private Long referenceId;

    public static Builder builder() {
        return new Builder();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(Long workItemId) {
        this.workItemId = workItemId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Long getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }

    public String toString() {
        return "NodeInstance{id=" + this.id + ", name='" + this.name + '\'' + ", processInstanceId=" + this.processInstanceId + ", workItemId=" + this.workItemId + ", containerId='" + this.containerId + '\'' + ", date=" + this.date + ", nodeId='" + this.nodeId + '\'' + ", nodeType='" + this.nodeType + '\'' + ", completed=" + this.completed + '}';
    }

    public static class Builder {
        private NodeInstance nodeInstance = new NodeInstance();

        public NodeInstance build() {
            return this.nodeInstance;
        }

        public Builder id(Long id) {
            this.nodeInstance.setId(id);
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeInstance.setNodeId(nodeId);
            return this;
        }

        public Builder name(String name) {
            this.nodeInstance.setName(name);
            return this;
        }

        public Builder processInstanceId(Long processInstanceId) {
            this.nodeInstance.setProcessInstanceId(processInstanceId);
            return this;
        }

        public Builder workItemId(Long workItemId) {
            this.nodeInstance.setWorkItemId(workItemId);
            return this;
        }

        public Builder containerId(String containerId) {
            this.nodeInstance.setContainerId(containerId);
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.nodeInstance.setNodeType(nodeType);
            return this;
        }

        public Builder date(Date date) {
            this.nodeInstance.setDate(date == null ? date : new Date(date.getTime()));
            return this;
        }

        public Builder connection(String connection) {
            this.nodeInstance.setConnection(connection);
            return this;
        }

        public Builder completed(Boolean completed) {
            this.nodeInstance.setCompleted(completed);
            return this;
        }

        public Builder referenceId(Long referenceId) {
            this.nodeInstance.setReferenceId(referenceId);
            return this;
        }
    }
}

