/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ReleaseIdFilter;

@RunWith(value=Parameterized.class)
public class ReleaseIdFilterTest {
    private static final ReleaseIdFilter FULL_FILTER = new ReleaseIdFilter("org.test", "example-artifactId", "1.0.0.Final");
    private static final ReleaseIdFilter GROUP_ID_ARTIFACT_ID_FILTER = new ReleaseIdFilter.Builder().groupId("org.test").artifactId("example-artifactId").build();
    private static final ReleaseIdFilter GROUP_ID_VERSION_FILTER = new ReleaseIdFilter.Builder().groupId("org.test").version("1.0.0.Final").build();
    private static final ReleaseIdFilter ARTIFACT_ID_VERSION_FILTER = new ReleaseIdFilter.Builder().artifactId("example-artifactId").version("1.0.0.Final").build();
    private static final ReleaseIdFilter GROUP_ID_FILTER = new ReleaseIdFilter.Builder().groupId("org.test").build();
    private static final ReleaseIdFilter ARTIFACT_ID_FILTER = new ReleaseIdFilter.Builder().artifactId("example-artifactId").build();
    private static final ReleaseIdFilter VERSION_FILTER = new ReleaseIdFilter.Builder().version("1.0.0.Final").build();
    private static final ReleaseId MATCHING_RELEASE_ID = new ReleaseId("org.test", "example-artifactId", "1.0.0.Final");
    private static final ReleaseId NON_MATCHING_RELEASE_ID = new ReleaseId("foo", "bar", "baz");
    @Parameterized.Parameter(value=0)
    public ReleaseIdFilter filter;
    @Parameterized.Parameter(value=1)
    public ReleaseId releaseId;
    @Parameterized.Parameter(value=2)
    public boolean expectedResult;

    @Parameterized.Parameters(name="{index}: filter={0}; releaseId={1}; expecting to match={2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>(Arrays.asList({FULL_FILTER, MATCHING_RELEASE_ID, true}, {FULL_FILTER, NON_MATCHING_RELEASE_ID, false}, {GROUP_ID_ARTIFACT_ID_FILTER, MATCHING_RELEASE_ID, true}, {GROUP_ID_ARTIFACT_ID_FILTER, NON_MATCHING_RELEASE_ID, false}, {GROUP_ID_VERSION_FILTER, MATCHING_RELEASE_ID, true}, {GROUP_ID_VERSION_FILTER, NON_MATCHING_RELEASE_ID, false}, {ARTIFACT_ID_VERSION_FILTER, MATCHING_RELEASE_ID, true}, {ARTIFACT_ID_VERSION_FILTER, NON_MATCHING_RELEASE_ID, false}, {GROUP_ID_FILTER, MATCHING_RELEASE_ID, true}, {GROUP_ID_FILTER, NON_MATCHING_RELEASE_ID, false}, {ARTIFACT_ID_FILTER, MATCHING_RELEASE_ID, true}, {ARTIFACT_ID_FILTER, NON_MATCHING_RELEASE_ID, false}, {VERSION_FILTER, MATCHING_RELEASE_ID, true}, {VERSION_FILTER, NON_MATCHING_RELEASE_ID, false}));
        return data;
    }

    @Test
    public void testAccept() {
        boolean result = this.filter.accept(this.releaseId);
        Assertions.assertThat((boolean)result).isEqualTo(this.expectedResult);
    }
}

