/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.AnotherMessage;
import org.kie.server.api.marshalling.objects.DateObject;
import org.kie.server.api.marshalling.objects.Message;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamMarshallerTest {
    private static final Logger logger = LoggerFactory.getLogger(XStreamMarshallerTest.class);

    @Test
    public void testXstreamMarshalWithAnnotation() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.Message>\n  <nameWithAlias>test content</nameWithAlias>\n</org.kie.server.api.marshalling.objects.Message>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        Message testMessage = new Message("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testXstreamMarshalWithCustomMarshallerBuilder() {
        String expectedXml = "<org.kie.server.api.marshalling.objects.AnotherMessage>\n  <another_name>test content</another_name>\n</org.kie.server.api.marshalling.objects.AnotherMessage>";
        HashSet<Class<Message>> extraClasses = new HashSet<Class<Message>>();
        extraClasses.add(Message.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        AnotherMessage testMessage = new AnotherMessage("test content");
        String testMessageString = marshaller.marshall((Object)testMessage);
        Assert.assertNotNull((Object)testMessageString);
        Assert.assertEquals((Object)expectedXml, (Object)testMessageString);
    }

    @Test
    public void testPMMLRequest() {
        PMMLRequestData request = new PMMLRequestData("123", "Test Model");
        request.addRequestParam("param1", (Object)10.0);
        request.addRequestParam("param2", (Object)"test string");
        HashSet<Class> extraClasses = new HashSet<Class>();
        extraClasses.add(PMMLRequestData.class);
        extraClasses.add(ParameterInfo.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        String marshalled = marshaller.marshall((Object)request);
        logger.debug(marshalled);
        PMMLRequestData rqst = (PMMLRequestData)marshaller.unmarshall(marshalled, PMMLRequestData.class);
        logger.info(rqst.toString());
    }

    @Test
    public void testUnmarshallListContainersCommandWithNoFilter() {
        String commandString = "<list-containers/>";
        Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        ListContainersCommand command = (ListContainersCommand)marshaller.unmarshall(commandString, ListContainersCommand.class);
        Assertions.assertThat((Object)command.getKieContainerResourceFilter()).isEqualTo((Object)KieContainerResourceFilter.ACCEPT_ALL);
    }

    @Test
    public void testMarshallDateObject() {
        String expectedString = "<date-object>\n  <localDate>2017-01-01</localDate>\n  <localDateTime>2017-01-01T10:10:10</localDateTime>\n  <localTime>10:10:10</localTime>\n  <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = new DateObject();
        dateObject.setLocalDate(LocalDate.of(2017, 1, 1));
        dateObject.setLocalDateTime(LocalDateTime.of(2017, 1, 1, 10, 10, 10));
        dateObject.setLocalTime(LocalTime.of(10, 10, 10));
        dateObject.setOffsetDateTime(OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)));
        String dateObjectString = marshaller.marshall((Object)dateObject);
        Assert.assertNotNull((Object)dateObjectString);
        Assert.assertEquals((Object)expectedString, (Object)dateObjectString);
    }

    @Test
    public void testUnmarshallDateObject() {
        String expectedString = "<date-object>\n  <localDate>2017-01-01</localDate>\n  <localDateTime>2017-01-01T10:10:10</localDateTime>\n  <localTime>10:10:10</localTime>\n  <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n</date-object>";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class);
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
    }

    @Test
    public void testUnmarshallDateObjectWithExtraField() {
        String expectedString = "<date-object>\n  <localDate>2017-01-01</localDate>\n  <localDateTime>2017-01-01T10:10:10</localDateTime>\n  <localTime>10:10:10</localTime>\n  <offsetDateTime>2017-01-01T10:10:10+01:00</offsetDateTime>\n  <unknownField>jojojojo</unknownField>\n</date-object>";
        HashSet<Class<DateObject>> extraClasses = new HashSet<Class<DateObject>>();
        extraClasses.add(DateObject.class);
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertThrows(AbstractReflectionConverter.UnknownFieldException.class, () -> marshaller.unmarshall(expectedString, DateObject.class));
        DateObject dateObject = (DateObject)marshaller.unmarshall(expectedString, DateObject.class, Collections.singletonMap("ignore-unknown-elements", Boolean.TRUE));
        Assert.assertNotNull((Object)dateObject);
        Assert.assertEquals((Object)LocalDate.of(2017, 1, 1), (Object)dateObject.getLocalDate());
        Assert.assertEquals((Object)LocalDateTime.of(2017, 1, 1, 10, 10, 10), (Object)dateObject.getLocalDateTime());
        Assert.assertEquals((Object)LocalTime.of(10, 10, 10), (Object)dateObject.getLocalTime());
        Assert.assertEquals((Object)OffsetDateTime.of(LocalDateTime.of(2017, 1, 1, 10, 10, 10), ZoneOffset.ofHours(1)), (Object)dateObject.getOffsetDateTime());
        Assert.assertThrows(AbstractReflectionConverter.UnknownFieldException.class, () -> marshaller.unmarshall(expectedString, DateObject.class));
    }
}

