/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.LookupCache;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.objects.CustomPerson;

public class JSONMarshallerTypeFactoryTest {
    @Test
    public void testTypeFactoryCacheSize() {
        HashSet<Class<CustomPerson>> extraClasses = new HashSet<Class<CustomPerson>>();
        extraClasses.add(CustomPerson.class);
        Marshaller marshaller1 = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        CustomPerson john = new CustomPerson("John", 20);
        InsertObjectCommand command1 = new InsertObjectCommand((Object)john);
        marshaller1.marshall((Object)command1);
        Marshaller marshaller2 = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        CustomPerson paul = new CustomPerson("Paul", 17);
        InsertObjectCommand command2 = new InsertObjectCommand((Object)paul);
        marshaller2.marshall((Object)command2);
        TypeFactory typeFactory1 = ((JSONMarshaller)marshaller1).getTypeFactory();
        TypeFactory typeFactory2 = ((JSONMarshaller)marshaller2).getTypeFactory();
        try {
            Field field = TypeFactory.class.getDeclaredField("_typeCache");
            field.setAccessible(true);
            LookupCache _typeCache1 = (LookupCache)field.get(typeFactory1);
            LookupCache _typeCache2 = (LookupCache)field.get(typeFactory2);
            Assertions.assertThat((int)_typeCache1.size()).isPositive();
            Assertions.assertThat((int)_typeCache2.size()).isPositive();
            marshaller1.dispose();
            Assertions.assertThat((int)_typeCache1.size()).isZero();
            Assertions.assertThat((int)_typeCache2.size()).isPositive();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Assertions.fail((String)"failed with reflection", (Throwable)e);
        }
    }
}

