/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.server.api.marshalling.BaseMarshallerBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerBuilder;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.Pojo1;
import org.kie.server.api.marshalling.objects.Pojo2;
import org.kie.server.api.marshalling.objects.Pojo3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsCommandNestedPojoMarshallingTest {
    private static final Logger logger = LoggerFactory.getLogger(DroolsCommandNestedPojoMarshallingTest.class);
    private static final String jaxbExpectedPayload = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<batch-execution>\n    <insert out-identifier=\"fact-pojo1\" return-object=\"true\" entry-point=\"DEFAULT\" disconnected=\"false\">\n        <object xsi:type=\"pojo1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n            <desc>C</desc>\n            <pojo2>\n                <desc2>B</desc2>\n                <pojo3>\n                    <desc3>A</desc3>\n                </pojo3>\n                <primitiveBoolean>true</primitiveBoolean>\n            </pojo2>\n        </object>\n    </insert>\n    <fire-all-rules max=\"-1\" out-identifier=\"fire-result\"/>\n</batch-execution>\n";
    private static final String xstreamExpectedPayload = "<batch-execution>\n  <insert out-identifier=\"fact-pojo1\" return-object=\"true\" entry-point=\"DEFAULT\">\n    <org.kie.server.api.marshalling.objects.Pojo1>\n      <desc>C</desc>\n      <pojo2>\n        <desc2>B</desc2>\n        <primitiveBoolean>true</primitiveBoolean>\n        <pojo3>\n          <desc3>A</desc3>\n        </pojo3>\n      </pojo2>\n    </org.kie.server.api.marshalling.objects.Pojo1>\n  </insert>\n  <fire-all-rules out-identifier=\"fire-result\"/>\n</batch-execution>";
    private static final String jsonExpectedPayload = "{\n  \"lookup\" : null,\n  \"commands\" : [ {\n    \"insert\" : {\n      \"object\" : {\"org.kie.server.api.marshalling.objects.Pojo1\":{\n  \"desc\" : \"C\",\n  \"pojo2\" : {\n    \"desc2\" : \"B\",\n    \"primitiveBoolean\" : true,\n    \"pojo3\" : {\n      \"desc3\" : \"A\"\n    }\n  }\n}},\n      \"out-identifier\" : \"fact-pojo1\",\n      \"return-object\" : true,\n      \"entry-point\" : \"DEFAULT\",\n      \"disconnected\" : false\n    }\n  }, {\n    \"fire-all-rules\" : {\n      \"max\" : -1,\n      \"agendaFilter\" : null,\n      \"out-identifier\" : \"fire-result\"\n    }\n  } ]\n}";
    private MarshallerBuilder marshallerBuilder = new BaseMarshallerBuilder();

    private static BatchExecutionCommand createTestCommand() {
        KieCommands commandsFactory = KieServices.Factory.get().getCommands();
        ArrayList<Command> commands = new ArrayList<Command>();
        Pojo3 pojo3 = new Pojo3("A");
        Pojo2 pojo2 = new Pojo2("B", true, pojo3);
        Pojo1 pojo1 = new Pojo1("C", pojo2);
        commands.add(commandsFactory.newInsert((Object)pojo1, "fact-pojo1"));
        commands.add(commandsFactory.newFireAllRules("fire-result"));
        BatchExecutionCommand batchExecution = commandsFactory.newBatchExecution(commands);
        return batchExecution;
    }

    private Set<Class<?>> getCustomClasses() {
        HashSet classes = new HashSet();
        classes.add(Pojo1.class);
        classes.add(Pojo2.class);
        classes.add(Pojo3.class);
        return classes;
    }

    @Test
    public void testJaxb() {
        Marshaller marshaller = this.marshallerBuilder.build(this.getCustomClasses(), MarshallingFormat.JAXB, this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, DroolsCommandNestedPojoMarshallingTest.createTestCommand(), jaxbExpectedPayload);
    }

    @Test
    public void testXStream() {
        Marshaller marshaller = this.marshallerBuilder.build(this.getCustomClasses(), MarshallingFormat.XSTREAM, this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, DroolsCommandNestedPojoMarshallingTest.createTestCommand(), xstreamExpectedPayload);
    }

    @Test
    public void testJSON() {
        Marshaller marshaller = this.marshallerBuilder.build(this.getCustomClasses(), MarshallingFormat.JSON, this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, DroolsCommandNestedPojoMarshallingTest.createTestCommand(), jsonExpectedPayload);
    }

    private void verifyMarshallingRoundTrip(Marshaller marshaller, BatchExecutionCommand inputCommand, String expectedPayload) {
        String rawContent = marshaller.marshall((Object)inputCommand);
        logger.debug(rawContent);
        Assertions.assertThat((String)rawContent).isEqualToIgnoringWhitespace((CharSequence)expectedPayload);
        BatchExecutionCommandImpl inputBatch = (BatchExecutionCommandImpl)inputCommand;
        BatchExecutionCommandImpl resultBatch = (BatchExecutionCommandImpl)marshaller.unmarshall(rawContent, inputCommand.getClass());
        Assert.assertEquals((Object)inputBatch.getLookup(), (Object)resultBatch.getLookup());
        Assert.assertEquals((long)inputBatch.getDistance(), (long)resultBatch.getDistance());
        InsertObjectCommand inputInsert = (InsertObjectCommand)inputBatch.getCommands().get(0);
        InsertObjectCommand resultInsert = (InsertObjectCommand)resultBatch.getCommands().get(0);
        Assert.assertEquals((Object)inputInsert.getEntryPoint(), (Object)resultInsert.getEntryPoint());
        Assert.assertEquals((Object)inputInsert.getObject(), (Object)resultInsert.getObject());
        Assert.assertEquals((Object)inputInsert.getOutIdentifier(), (Object)resultInsert.getOutIdentifier());
        Assert.assertEquals((Object)inputInsert.isDisconnected(), (Object)resultInsert.isDisconnected());
        Assert.assertEquals((Object)inputInsert.isReturnObject(), (Object)resultInsert.isReturnObject());
    }
}

