/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import java.util.HashSet;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class JSONMarshallerWithSystemPropertyTest {
    @BeforeClass
    public static void init() {
        System.setProperty("org.kie.server.strict.javaBeans.serializers", "true");
    }

    @AfterClass
    public static void tearDown() {
        System.clearProperty("org.kie.server.strict.javaBeans.serializers");
    }

    @Test
    public void testCapitalizedWrapObjectFieldnamesWithProperty() throws Exception {
        Marshaller marshaller = MarshallerFactory.getMarshaller(new HashSet(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        BatchExecutionCommandImpl batch = new BatchExecutionCommandImpl();
        batch.addCommand((Command)new InsertObjectCommand((Object)new Order("all")));
        String converted = marshaller.marshall((Object)batch);
        String expectedMarshalled = "{ \"lookup\" : null, \"commands\" : [ { \"insert\" : { \"object\" : {\"org.kie.server.api.marshalling.JSONMarshallerWithSystemPropertyTest$Order\":{ \"ORDER_ID\" : \"all\" }}, \"out-identifier\" : null, \"return-object\" : true, \"entry-point\" : \"DEFAULT\", \"disconnected\" : false } } ] }";
        JSONAssert.assertEquals((String)expectedMarshalled, (String)converted, (JSONCompareMode)JSONCompareMode.STRICT);
        BatchExecutionCommandImpl unconverted = (BatchExecutionCommandImpl)marshaller.unmarshall(converted, BatchExecutionCommandImpl.class);
        Assert.assertEquals((Object)"all", (Object)((Order)((InsertObjectCommand)unconverted.getCommands().get(0)).getObject()).getORDER_ID());
    }

    public static class Order {
        private String ORDER_ID;

        public Order() {
        }

        public Order(String o) {
            this.ORDER_ID = o;
        }

        public String getORDER_ID() {
            return this.ORDER_ID;
        }

        public void setORDER_ID(String o) {
            this.ORDER_ID = o;
        }
    }
}

