/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.core.util.IoUtils;
import org.junit.Test;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.marshalling.test.model.Fact;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMarshallerLargeTest {
    private Logger logger = LoggerFactory.getLogger(JSONMarshallerLargeTest.class);

    @Test(timeout=5000L)
    public void testLargeNumberOfClasses() throws IOException {
        try (InputStream is = JSONMarshallerLargeTest.class.getClassLoader().getResourceAsStream("complex_payload.json");){
            String content = new String(IoUtils.readBytesFromInputStream((InputStream)is));
            Reflections reflections = new Reflections("org.kie.server.api.marshalling.test.model", new Scanner[]{new SubTypesScanner(false)});
            Set clazzes = reflections.getSubTypesOf(Object.class).stream().collect(Collectors.toSet());
            clazzes.remove(Fact.class);
            JSONMarshaller marshaller = new JSONMarshaller(clazzes, JSONMarshallerLargeTest.class.getClassLoader());
            Fact object = (Fact)marshaller.unmarshall(content, Fact.class);
            Assertions.assertThat((Object)object).isNotNull();
            this.logger.info("object captured {}", (Object)object);
        }
    }
}

