/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;

public class JSONUnmarshallingTest {
    @Test
    public void testNonExistingClassDefault() {
        try {
            Object obj = this.unmarshalNonExistingClass();
            Assert.assertEquals(LinkedHashMap.class, obj.getClass());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    @Test
    public void testNonExistingClassWarn() {
        try {
            System.setProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior", "WARN");
            Object obj = this.unmarshalNonExistingClass();
            Assert.assertEquals(LinkedHashMap.class, obj.getClass());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    @Test
    public void testNonExistingClassException() {
        try {
            System.setProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior", "EXCEPTION");
            Assert.assertThrows(MarshallingException.class, () -> this.unmarshalNonExistingClass());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    @Test
    public void testWrongCNFEBehaviorValue() {
        try {
            System.setProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior", "XXX");
            MarshallingException exception = (MarshallingException)Assert.assertThrows(MarshallingException.class, () -> this.unmarshalNonExistingClass());
            Assertions.assertThat((String)exception.getMessage()).contains(Arrays.asList("IGNORE", "WARN", "EXCEPTION"));
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    private Object unmarshalNonExistingClass() {
        HashSet extraClasses = new HashSet();
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        String json = "{\"com.nonexisting.Person\":{\"name\":\"taro\",\"age\":\"20\"}}";
        return marshaller.unmarshall(json, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonExistingClassDefaultInDroolsCommand() {
        try {
            Object obj = this.unmarshalNonExistingClassInDroolsCommand();
            Assert.assertEquals(BatchExecutionCommandImpl.class, obj.getClass());
            BatchExecutionCommandImpl batch = (BatchExecutionCommandImpl)obj;
            Command command = (Command)batch.getCommands().get(0);
            Assert.assertEquals(InsertObjectCommand.class, command.getClass());
            Assert.assertEquals(LinkedHashMap.class, ((InsertObjectCommand)command).getObject().getClass());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonExistingClassWarnInDroolsCommand() {
        try {
            System.setProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior", "WARN");
            Object obj = this.unmarshalNonExistingClassInDroolsCommand();
            Assert.assertEquals(BatchExecutionCommandImpl.class, obj.getClass());
            BatchExecutionCommandImpl batch = (BatchExecutionCommandImpl)obj;
            Command command = (Command)batch.getCommands().get(0);
            Assert.assertEquals(InsertObjectCommand.class, command.getClass());
            Assert.assertEquals(LinkedHashMap.class, ((InsertObjectCommand)command).getObject().getClass());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    @Test
    public void testNonExistingClassExceptionInDroolsCommand() {
        try {
            System.setProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior", "EXCEPTION");
            Assert.assertThrows(MarshallingException.class, () -> this.unmarshalNonExistingClassInDroolsCommand());
        }
        finally {
            System.clearProperty("org.kie.server.json.customObjectDeserializerCNFEBehavior");
        }
    }

    private Object unmarshalNonExistingClassInDroolsCommand() {
        HashSet extraClasses = new HashSet();
        Marshaller marshaller = MarshallerFactory.getMarshaller(extraClasses, (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        String json = "{\n  \"lookup\" : \"StatelessKieSession\",\n    \"commands\" : [ {\n      \"insert\" : {\n        \"object\" : {\"com.nonexisting.Person\":{\"name\":\"taro\",\"age\":\"20\"}},\n        \"out-identifier\" : \"person\",\n        \"return-object\" : \"true\",\n        \"entry-point\" : \"DEFAULT\"\n       }\n    }, {\n        \"fire-all-rules\" : { }\n   } ]\n}";
        return marshaller.unmarshall(json, BatchExecutionCommandImpl.class);
    }
}

