/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.FireUntilHaltCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DisconnectedFactHandle;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieServices;
import org.kie.api.command.Setter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.CommandFactory;
import org.kie.server.api.marshalling.BaseMarshallerBuilder;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerBuilder;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.SimplePojo;

@RunWith(value=Parameterized.class)
public class DroolsCommandsMarshallingTest {
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;
    private MarshallerBuilder marshallerBuilder = new BaseMarshallerBuilder();
    private static Set<Class<?>> extraClasses = new HashSet();
    private static final Random random = new Random();

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return new ArrayList<Object[]>(Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON}, {MarshallingFormat.XSTREAM}));
    }

    @BeforeClass
    public static void setUp() {
        extraClasses.add(SimplePojo.class);
    }

    private void verifyDisconnectedFactHandle(DisconnectedFactHandle orig, DisconnectedFactHandle copy) {
        Assert.assertNotNull((String)"copy disconnected fact handle is null", (Object)copy);
        Assert.assertEquals((String)"id", (long)orig.getId(), (long)copy.getId());
        Assert.assertEquals((String)"identity hash code", (long)orig.getIdentityHashCode(), (long)copy.getIdentityHashCode());
        Assert.assertEquals((String)"object hash code", (long)orig.getObjectHashCode(), (long)copy.getObjectHashCode());
        Assert.assertEquals((String)"recency", (long)orig.getRecency(), (long)copy.getRecency());
        Assert.assertEquals((String)"entry point id", (Object)orig.getEntryPointId(), (Object)copy.getEntryPointId());
        Assert.assertEquals((String)"trait type", (Object)orig.getTraitType(), (Object)copy.getTraitType());
    }

    private <T> T roundTrip(T obj) {
        Class<?> type = obj.getClass();
        Marshaller marshaller = this.marshallerBuilder.build(extraClasses, this.marshallingFormat, this.getClass().getClassLoader());
        String strOut = marshaller.marshall(obj);
        return (T)marshaller.unmarshall(strOut, type);
    }

    private static String randomString() {
        return UUID.randomUUID().toString();
    }

    @Test
    public void testFireAllRulesCommandAgendaFilter() {
        RuleNameEndsWithAgendaFilter filter = new RuleNameEndsWithAgendaFilter("suffix", true);
        FireAllRulesCommand command = new FireAllRulesCommand(DroolsCommandsMarshallingTest.randomString(), random.nextInt(1000), (AgendaFilter)filter);
        FireAllRulesCommand result = this.roundTrip(command);
        Assert.assertEquals((long)command.getMax(), (long)result.getMax());
        Assert.assertEquals(RuleNameEndsWithAgendaFilter.class, result.getAgendaFilter().getClass());
        RuleNameEndsWithAgendaFilter filterResult = (RuleNameEndsWithAgendaFilter)result.getAgendaFilter();
        Assert.assertEquals((Object)filter.getSuffix(), (Object)filterResult.getSuffix());
        Assert.assertEquals((Object)filter.isAccept(), (Object)filterResult.isAccept());
    }

    @Test
    public void testFireUntilHaltCommandAgendaFilter() {
        RuleNameEndsWithAgendaFilter filter = new RuleNameEndsWithAgendaFilter("suffix", true);
        FireUntilHaltCommand command = new FireUntilHaltCommand((AgendaFilter)filter);
        FireUntilHaltCommand result = this.roundTrip(command);
        Assert.assertEquals(RuleNameEndsWithAgendaFilter.class, result.getAgendaFilter().getClass());
        RuleNameEndsWithAgendaFilter filterResult = (RuleNameEndsWithAgendaFilter)result.getAgendaFilter();
        Assert.assertEquals((Object)filter.getSuffix(), (Object)filterResult.getSuffix());
        Assert.assertEquals((Object)filter.isAccept(), (Object)filterResult.isAccept());
    }

    @Test
    public void testInsertObjectCommand() {
        InsertObjectCommand command = (InsertObjectCommand)CommandFactory.newInsert((Object)"String value");
        InsertObjectCommand result = this.roundTrip(command);
        Assert.assertEquals((Object)"String value", (Object)result.getObject().toString());
    }

    @Test
    public void testModifyCommand() {
        DefaultFactHandle factHandle = DefaultFactHandle.createFromExternalFormat((String)"0:234:345:456:567:789");
        List<Setter> setters = Arrays.asList(CommandFactory.newSetter((String)"age", (String)"30"), CommandFactory.newSetter((String)"salary", (String)"5000"));
        ModifyCommand command = (ModifyCommand)CommandFactory.newModify((FactHandle)factHandle, setters);
        ModifyCommand result = this.roundTrip(command);
        Assert.assertEquals((long)2L, (long)result.getSetters().size());
        Assert.assertEquals((Object)"0:234:345:456:567:789:NON_TRAIT:null", (Object)result.getFactHandle().toExternalForm());
    }

    @Test
    public void testUpdateCommand() {
        SimplePojo pojo = new SimplePojo("ID12345", 100, "string-data");
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2L, 3, 4, 5L, "entry-point-id", (Object)pojo, true);
        SimplePojo updatedPojo = new SimplePojo("ID12345", 200, "updated-string-data");
        String[] modifiedProperties = new String[]{"intData", "stringData"};
        UpdateCommand command = new UpdateCommand((FactHandle)discFactHandle, (Object)updatedPojo, modifiedProperties);
        UpdateCommand result = this.roundTrip(command);
        this.verifyDisconnectedFactHandle(discFactHandle, result.getHandle());
        Assert.assertEquals((Object)command.getEntryPoint(), (Object)result.getEntryPoint());
        Assert.assertEquals((Object)command.getObject(), (Object)result.getObject());
        Assert.assertEquals(Arrays.asList(command.getModifiedProperties()), Arrays.asList(result.getModifiedProperties()));
    }

    @Test
    public void testUpdateCommandInsideBatch() {
        SimplePojo pojo = new SimplePojo("ID12345", 100, "string-data");
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2L, 3, 4, 5L, "entry-point-id", (Object)pojo, true);
        SimplePojo updatedPojo = new SimplePojo("ID12345", 200, "updated-string-data");
        String[] modifiedProperties = new String[]{"intData", "stringData"};
        UpdateCommand command = new UpdateCommand((FactHandle)discFactHandle, (Object)updatedPojo, modifiedProperties);
        ArrayList<UpdateCommand> commands = new ArrayList<UpdateCommand>();
        BatchExecutionCommandImpl batch = (BatchExecutionCommandImpl)KieServices.Factory.get().getCommands().newBatchExecution(commands, "myKieSession");
        commands.add(command);
        BatchExecutionCommandImpl batchResult = this.roundTrip(batch);
        UpdateCommand result = (UpdateCommand)batchResult.getCommands().get(0);
        this.verifyDisconnectedFactHandle(discFactHandle, result.getHandle());
        Assert.assertEquals((Object)command.getEntryPoint(), (Object)result.getEntryPoint());
        Assert.assertEquals((Object)command.getObject(), (Object)result.getObject());
        Assert.assertEquals(Arrays.asList(command.getModifiedProperties()), Arrays.asList(result.getModifiedProperties()));
    }

    @Test
    public void testGetObjectCommand() {
        DisconnectedFactHandle discFactHandle = new DisconnectedFactHandle(2L, 3, 4, 5L, "entry-point-id", (Object)"str-obj", true);
        GetObjectCommand command = new GetObjectCommand((FactHandle)discFactHandle, "out-id");
        GetObjectCommand result = this.roundTrip(command);
        this.verifyDisconnectedFactHandle(discFactHandle, result.getDisconnectedFactHandle());
        Assert.assertEquals((Object)command.getOutIdentifier(), (Object)result.getOutIdentifier());
    }
}

