/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.rest;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.client.rest.RestKieServerControllerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class RestKieServerControllerClientTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestKieServerControllerClientTest.class);
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;
    private RestKieServerControllerClient client;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON});
    }

    @Before
    public void before() {
        this.client = new RestKieServerControllerClient(null, null, null, this.marshallingFormat);
    }

    @Test
    public void testContainerSpecSerialization() {
        ContainerSpec spec = new ContainerSpec();
        spec.setId("id");
        spec.setContainerName("name");
        spec.setStatus(KieContainerStatus.STARTED);
        spec.setReleasedId(new ReleaseId("groupId", "artifactId", "1.0"));
        ProcessConfig processConfig = new ProcessConfig("runtimeStrategy", "kBase", "kSession", "mergeMode");
        spec.addConfig(Capability.PROCESS, (ContainerConfig)processConfig);
        RuleConfig ruleConfig = new RuleConfig(Long.valueOf(1L), KieScannerStatus.SCANNING);
        spec.addConfig(Capability.RULE, (ContainerConfig)ruleConfig);
        String specContent = this.client.serialize((Object)spec);
        LOGGER.info("{} content\n{}", (Object)this.marshallingFormat.getType(), (Object)specContent);
        ContainerSpec specResult = (ContainerSpec)this.client.deserialize(specContent, ContainerSpec.class);
        Assert.assertNotNull((Object)specResult);
        Assert.assertEquals((Object)spec, (Object)specResult);
        Assert.assertEquals((Object)spec.getId(), (Object)specResult.getId());
        Assert.assertEquals((Object)spec.getStatus(), (Object)specResult.getStatus());
        Assert.assertEquals((Object)spec.getContainerName(), (Object)specResult.getContainerName());
        Assert.assertEquals((Object)spec.getConfigs(), (Object)specResult.getConfigs());
        Assert.assertEquals((Object)spec.getReleasedId(), (Object)specResult.getReleasedId());
        Assert.assertNotNull((Object)specResult.getConfigs());
        ContainerConfig processConfigResult = (ContainerConfig)specResult.getConfigs().get(Capability.PROCESS);
        Assert.assertNotNull((Object)processConfigResult);
        Assert.assertTrue((boolean)(processConfigResult instanceof ProcessConfig));
        Assert.assertEquals((Object)processConfig, (Object)processConfigResult);
        ContainerConfig ruleConfigResult = (ContainerConfig)specResult.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigResult);
        Assert.assertTrue((boolean)(ruleConfigResult instanceof RuleConfig));
        Assert.assertEquals((Object)ruleConfig, (Object)ruleConfigResult);
    }
}

