/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.websocket;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.client.websocket.WebSocketKieServerControllerClient;
import org.kie.server.controller.websocket.common.KieServerControllerNotificationWebSocketClient;
import org.kie.server.controller.websocket.common.KieServerMessageHandlerWebSocketClient;
import org.kie.server.controller.websocket.common.WebSocketUtils;
import org.kie.server.controller.websocket.common.handlers.InternalMessageHandler;
import org.kie.server.controller.websocket.common.handlers.WebSocketServiceResponse;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketKieServerControllerClientTest {
    private static final String UPDATE_CONTAINER_SPEC_METHOD = "updateContainerSpec";
    private static final String SERVER_TEMPLATE_ID = "templateId";
    private static final String CONTAINER_ID = "containerId";
    @Mock
    private KieServerMessageHandlerWebSocketClient client;
    @Mock
    private KieServerControllerNotificationWebSocketClient notificationClient;
    @InjectMocks
    @Spy
    private WebSocketKieServerControllerClient controllerClient;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.controllerClient.getMessageHandler()).thenReturn((Object)((WebSocketServiceResponse)Mockito.mock(WebSocketServiceResponse.class)));
    }

    @Test
    public void testServiceMethods() throws Exception {
        this.verifyServiceMethods(SpecManagementService.class);
        this.verifyServiceMethods(RuntimeManagementService.class);
        this.verifyServiceMethods(RuleCapabilitiesService.class);
    }

    private void verifyServiceMethods(Class service) throws Exception {
        String name = service.getName();
        Method[] methods = service.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            MethodUtils.invokeMethod((Object)this.controllerClient, (String)m.getName(), (Object[])new Object[m.getParameterCount()]);
            ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
            ((KieServerMessageHandlerWebSocketClient)Mockito.verify((Object)this.client)).sendTextWithInternalHandler((String)contentCaptor.capture(), (InternalMessageHandler)Matchers.any(InternalMessageHandler.class));
            DescriptorCommand command = (DescriptorCommand)WebSocketUtils.unmarshal((String)((String)contentCaptor.getValue()), DescriptorCommand.class);
            Assert.assertNotNull((Object)command);
            Assert.assertEquals((Object)name, (Object)command.getService());
            Assert.assertEquals((Object)m.getName(), (Object)command.getMethod());
            Mockito.reset((Object[])new KieServerMessageHandlerWebSocketClient[]{this.client});
        }
    }

    @Test
    public void testClose() throws Exception {
        this.controllerClient.close();
        ((KieServerMessageHandlerWebSocketClient)Mockito.verify((Object)this.client)).close();
        ((KieServerControllerNotificationWebSocketClient)Mockito.verify((Object)this.notificationClient)).close();
    }

    @Test
    public void testUpdateContainerSpecDefaultMethod() throws IOException {
        this.controllerClient.updateContainerSpec(SERVER_TEMPLATE_ID, CONTAINER_ID, new ContainerSpec());
        this.checkUpdateContainerSpec(false);
    }

    @Test
    public void testUpdateContainerSpecWithoutAbortingInstances() throws IOException {
        this.controllerClient.updateContainerSpec(SERVER_TEMPLATE_ID, CONTAINER_ID, new ContainerSpec(), Boolean.valueOf(false));
        this.checkUpdateContainerSpec(false);
    }

    @Test
    public void testUpdateContainerSpecAbortingInstances() throws IOException {
        this.controllerClient.updateContainerSpec(SERVER_TEMPLATE_ID, CONTAINER_ID, new ContainerSpec(), Boolean.valueOf(true));
        this.checkUpdateContainerSpec(true);
    }

    private void checkUpdateContainerSpec(boolean expected) throws IOException {
        ((WebSocketKieServerControllerClient)Mockito.verify((Object)this.controllerClient)).updateContainerSpec((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (String)Mockito.eq((Object)CONTAINER_ID), (ContainerSpec)Matchers.any(ContainerSpec.class), Boolean.valueOf(Mockito.eq((boolean)expected)));
        ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
        ((KieServerMessageHandlerWebSocketClient)Mockito.verify((Object)this.client)).sendTextWithInternalHandler((String)contentCaptor.capture(), (InternalMessageHandler)Matchers.any(InternalMessageHandler.class));
        DescriptorCommand command = (DescriptorCommand)WebSocketUtils.unmarshal((String)((String)contentCaptor.getValue()), DescriptorCommand.class);
        Assert.assertNotNull((Object)command);
        Assert.assertEquals((Object)UPDATE_CONTAINER_SPEC_METHOD, (Object)command.getMethod());
        Assert.assertEquals((long)4L, (long)command.getArguments().size());
        Assert.assertEquals((Object)SERVER_TEMPLATE_ID, command.getArguments().get(0));
        Assert.assertEquals((Object)CONTAINER_ID, command.getArguments().get(1));
        Assert.assertEquals((Object)expected, command.getArguments().get(3));
    }
}

