/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.websocket;

import java.util.ArrayList;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.client.event.EventHandler;
import org.kie.server.controller.client.websocket.WebSocketEventHandler;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebSocketEventHandlerTest {
    @Mock
    EventHandler eventHandler;
    @InjectMocks
    WebSocketEventHandler handler;

    @Test
    public void testInvalidEvent() {
        this.handler.accept((KieServerControllerEvent)Mockito.mock(KieServerControllerEvent.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerInstanceConnected() {
        this.handler.accept((KieServerControllerEvent)new ServerInstanceConnected(new ServerInstance()));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerInstanceConnected((ServerInstanceConnected)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerInstanceDisconnected() {
        this.handler.accept((KieServerControllerEvent)new ServerInstanceDisconnected("serverId"));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerInstanceDisconnected((ServerInstanceDisconnected)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerInstanceDeleted() {
        this.handler.accept((KieServerControllerEvent)new ServerInstanceDeleted("serverId"));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerInstanceDeleted((ServerInstanceDeleted)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerInstanceUpdated() {
        this.handler.accept((KieServerControllerEvent)new ServerInstanceUpdated(new ServerInstance()));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerInstanceUpdated((ServerInstanceUpdated)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerTemplateUpdated() {
        this.handler.accept((KieServerControllerEvent)new ServerTemplateUpdated(new ServerTemplate()));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerTemplateUpdated((ServerTemplateUpdated)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testServerTemplateDeleted() {
        this.handler.accept((KieServerControllerEvent)new ServerTemplateDeleted("serverTemplateId"));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onServerTemplateDeleted((ServerTemplateDeleted)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }

    @Test
    public void testContainerSpecUpdated() {
        this.handler.accept((KieServerControllerEvent)new ContainerSpecUpdated(new ServerTemplate(), new ContainerSpec(), new ArrayList()));
        ((EventHandler)Mockito.verify((Object)this.eventHandler)).onContainerSpecUpdated((ContainerSpecUpdated)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.eventHandler});
    }
}

