/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.HashSet;
import java.util.Set;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.api.storage.KieServerStorageAware;
import org.kie.server.controller.impl.storage.InMemoryKieServerControllerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerControllerImpl
implements KieServerController,
KieServerStorageAware {
    private static final Logger logger = LoggerFactory.getLogger(KieServerControllerImpl.class);
    private KieServerControllerStorage storage = InMemoryKieServerControllerStorage.getInstance();

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerInstance kieServerInstance = this.storage.load(serverInfo.getServerId());
        if (kieServerInstance != null) {
            logger.debug("Server id {} know to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            KieServerInstanceInfo instanceInfo = this.findByServerInfo(serverInfo, kieServerInstance);
            if (instanceInfo == null) {
                logger.debug("Server instance '{}' not yet registered", (Object)serverInfo.getLocation());
                instanceInfo = new KieServerInstanceInfo(serverInfo.getLocation(), KieServerStatus.UP, serverInfo.getCapabilities());
                kieServerInstance.getManagedInstances().add(instanceInfo);
            } else {
                logger.debug("Server instance {} already registered, changing its status to {}", (Object)serverInfo.getLocation(), (Object)KieServerStatus.UP);
                instanceInfo.setStatus(KieServerStatus.UP);
            }
            logger.debug("KieServerInstance updated after connect from server {}", (Object)serverInfo.getLocation());
            this.storage.update(kieServerInstance);
        } else {
            logger.debug("Server id {} unknown to this controller, registering...", (Object)serverInfo.getServerId());
            kieServerInstance = new KieServerInstance();
            kieServerInstance.setIdentifier(serverInfo.getServerId());
            kieServerInstance.setName(serverInfo.getName());
            kieServerInstance.setVersion(serverInfo.getVersion());
            kieServerInstance.setKieServerSetup(new KieServerSetup());
            kieServerInstance.setStatus(KieServerStatus.UP);
            kieServerInstance.setManagedInstances(new HashSet());
            KieServerInstanceInfo instanceInfo = new KieServerInstanceInfo(serverInfo.getLocation(), KieServerStatus.UP, serverInfo.getCapabilities());
            kieServerInstance.getManagedInstances().add(instanceInfo);
            logger.debug("KieServerInstance stored after connect (register) from server {}", (Object)serverInfo.getLocation());
            this.storage.store(kieServerInstance);
        }
        logger.info("Server {} connected to controller", (Object)serverInfo.getLocation());
        return kieServerInstance.getKieServerSetup();
    }

    public void disconnect(KieServerInfo serverInfo) {
        KieServerInstance kieServerInstance = this.storage.load(serverInfo.getServerId());
        if (kieServerInstance != null) {
            logger.debug("Server id {} know to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            KieServerInstanceInfo instanceInfo = this.findByServerInfo(serverInfo, kieServerInstance);
            if (instanceInfo != null) {
                logger.debug("Server instance {} already registered, changing its status to {}", (Object)serverInfo.getLocation(), (Object)KieServerStatus.DOWN);
                instanceInfo.setStatus(KieServerStatus.DOWN);
                logger.debug("KieServerInstance updated after disconnect from server {}", (Object)serverInfo.getLocation());
                this.storage.update(kieServerInstance);
                logger.info("Server {} disconnected from controller", (Object)serverInfo.getLocation());
            }
        }
    }

    public void setStorage(KieServerControllerStorage storage) {
        this.storage = storage;
    }

    public KieServerControllerStorage getStorage() {
        return this.storage;
    }

    protected KieServerInstanceInfo findByServerInfo(KieServerInfo serverInfo, KieServerInstance kieServerInstance) {
        Set managedInstances = kieServerInstance.getManagedInstances();
        if (managedInstances != null) {
            for (KieServerInstanceInfo managedInstance : managedInstances) {
                if (!serverInfo.getLocation().equals(managedInstance.getLocation())) continue;
                return managedInstance;
            }
        }
        return null;
    }
}

