/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.AbstractServiceImplTest;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SpecManagementServiceImplTest
extends AbstractServiceImplTest {
    @Before
    public void setup() {
        this.specManagementService = new SpecManagementServiceImpl();
        this.kieServerInstanceManager = (KieServerInstanceManager)Mockito.mock(KieServerInstanceManager.class);
        ((SpecManagementServiceImpl)this.specManagementService).setKieServerInstanceManager(this.kieServerInstanceManager);
    }

    @After
    public void cleanup() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
    }

    @Test
    public void testCreateServerTemplate() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        ServerTemplateKey saved = (ServerTemplateKey)existing.iterator().next();
        Assert.assertEquals((Object)serverTemplate.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)saved.getId());
    }

    @Test
    public void testCreateServerTemplateAndContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        Collection specs = this.specManagementService.listContainerSpec(serverTemplate.getId());
        Assert.assertNotNull((Object)specs);
        Assert.assertEquals((long)1L, (long)specs.size());
        container = (ContainerSpec)specs.iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
    }

    @Test
    public void testListServerTemplates() {
        int limit = this.getRandomInt(5, 10);
        for (int x = 0; x < limit; ++x) {
            ServerTemplate serverTemplate = new ServerTemplate();
            serverTemplate.setName("test server " + x);
            serverTemplate.setId(UUID.randomUUID().toString());
            this.specManagementService.saveServerTemplate(serverTemplate);
        }
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)limit, (long)existing.size());
        Collection allTemplates = this.specManagementService.listServerTemplates();
        Assert.assertNotNull((Object)allTemplates);
        Assert.assertEquals((long)limit, (long)allTemplates.size());
    }

    @Test
    public void testCreateAndDeleteServerTemplate() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        ServerTemplateKey saved = (ServerTemplateKey)existing.iterator().next();
        Assert.assertEquals((Object)serverTemplate.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)saved.getId());
        this.specManagementService.deleteServerTemplate(serverTemplate.getId());
        existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)0L, (long)existing.size());
    }

    @Test
    public void testCreateServerTemplateAndAddRemoveContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        int limit = this.getRandomInt(3, 6);
        for (int x = 0; x < limit; ++x) {
            HashMap configs = new HashMap();
            RuleConfig ruleConfig = new RuleConfig();
            ruleConfig.setPollInterval(Long.valueOf(1000L));
            ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
            ProcessConfig processConfig = new ProcessConfig();
            processConfig.setKBase("defaultKieBase");
            processConfig.setKSession("defaultKieSession");
            processConfig.setMergeMode("MERGE_COLLECTION");
            processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
            ContainerSpec containerSpec = new ContainerSpec();
            containerSpec.setId("test container " + x);
            containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", x + ".0"));
            containerSpec.setStatus(KieContainerStatus.STOPPED);
            containerSpec.setConfigs(configs);
            this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        }
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)limit, (long)createdServerTemplate.getContainersSpec().size());
        this.specManagementService.deleteContainerSpec(serverTemplate.getId(), "test container 0");
        createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)(limit - 1), (long)createdServerTemplate.getContainersSpec().size());
    }

    @Test
    public void testCreateServerTemplateAndCreateThenCopyContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        HashMap configs = new HashMap();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        String newServerTemplateId = "Copied server id";
        String newServerTemplateName = "Copied server name";
        this.specManagementService.copyServerTemplate(serverTemplate.getId(), newServerTemplateId, newServerTemplateName);
        existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)2L, (long)existing.size());
        createdServerTemplate = this.specManagementService.getServerTemplate(newServerTemplateId);
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertEquals((Object)newServerTemplateName, (Object)createdServerTemplate.getName());
        Assert.assertEquals((Object)newServerTemplateId, (Object)createdServerTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)newServerTemplateId, (Object)container.getServerTemplateKey().getId());
        Assert.assertEquals((Object)newServerTemplateName, (Object)container.getServerTemplateKey().getName());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
    }

    @Test
    public void testCreateServerTemplateAndUpdateContainerConfig() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        Collection existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.size());
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        ContainerConfig ruleConfigCurrent = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigCurrent);
        Assert.assertTrue((boolean)(ruleConfigCurrent instanceof RuleConfig));
        Assert.assertEquals((Object)ruleConfig.getPollInterval(), (Object)((RuleConfig)ruleConfigCurrent).getPollInterval());
        Assert.assertEquals((Object)ruleConfig.getScannerStatus(), (Object)((RuleConfig)ruleConfigCurrent).getScannerStatus());
        RuleConfig containerConfig = new RuleConfig();
        containerConfig.setScannerStatus(KieScannerStatus.SCANNING);
        containerConfig.setPollInterval(Long.valueOf(10L));
        this.specManagementService.updateContainerConfig(serverTemplate.getId(), containerSpec.getId(), Capability.RULE, (ContainerConfig)containerConfig);
        Collection specs = this.specManagementService.listContainerSpec(serverTemplate.getId());
        Assert.assertNotNull((Object)specs);
        Assert.assertEquals((long)1L, (long)specs.size());
        container = (ContainerSpec)specs.iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        ContainerConfig ruleConfigCurrent2 = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigCurrent2);
        Assert.assertTrue((boolean)(ruleConfigCurrent2 instanceof RuleConfig));
        Assert.assertEquals((Object)containerConfig.getPollInterval(), (Object)((RuleConfig)ruleConfigCurrent2).getPollInterval());
        Assert.assertEquals((Object)containerConfig.getScannerStatus(), (Object)((RuleConfig)ruleConfigCurrent2).getScannerStatus());
    }

    @Test
    public void testStartContainer() {
        this.createServerTemplateWithContainer();
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.startContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.specManagementService.startContainer((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).startContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Assert.assertNotNull((Object)updated);
        ContainerSpec updatedContainer = updated.getContainerSpec(this.containerSpec.getId());
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)updatedContainer.getStatus());
    }

    @Test
    public void testStopContainer() {
        this.createServerTemplateWithContainer();
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.stopContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.specManagementService.stopContainer((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).stopContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Assert.assertNotNull((Object)updated);
        ContainerSpec updatedContainer = updated.getContainerSpec(this.containerSpec.getId());
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)updatedContainer.getStatus());
    }

    protected int getRandomInt(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min + 1)) + min;
    }
}

