/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.AbstractServiceImplTest;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuntimeManagementServiceImplTest
extends AbstractServiceImplTest {
    @Before
    public void setup() {
        this.runtimeManagementService = new RuntimeManagementServiceImpl();
        this.specManagementService = new SpecManagementServiceImpl();
        this.kieServerInstanceManager = (KieServerInstanceManager)Mockito.mock(KieServerInstanceManager.class);
        ((RuntimeManagementServiceImpl)this.runtimeManagementService).setKieServerInstanceManager(this.kieServerInstanceManager);
        this.createServerTemplateWithContainer();
    }

    @After
    public void cleanup() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
    }

    @Test
    public void testGetServerInstances() {
        Collection found = this.runtimeManagementService.getServerInstances(this.serverTemplate.getId());
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((long)0L, (long)found.size());
        this.serverTemplate.addServerInstance(new ServerInstanceKey(this.serverTemplate.getId(), "test server", "instanceId", "http://fake.url.org"));
        this.specManagementService.saveServerTemplate(this.serverTemplate);
        found = this.runtimeManagementService.getServerInstances(this.serverTemplate.getId());
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((long)1L, (long)found.size());
        ServerInstanceKey server = (ServerInstanceKey)found.iterator().next();
        Assert.assertNotNull((Object)server);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)server.getServerTemplateId());
        Assert.assertEquals((Object)"instanceId", (Object)server.getServerInstanceId());
        Assert.assertEquals((Object)"test server", (Object)server.getServerName());
        Assert.assertEquals((Object)"http://fake.url.org", (Object)server.getUrl());
    }

    @Test
    public void testGetContainers() {
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.getContainers((ServerInstanceKey)Matchers.any(ServerInstanceKey.class))).thenReturn(fakeResult);
        ServerInstanceKey instanceKey = new ServerInstanceKey("instanceId", "test server", this.serverTemplate.getId(), "http://fake.url.org");
        this.serverTemplate.addServerInstance(instanceKey);
        this.specManagementService.saveServerTemplate(this.serverTemplate);
        Collection containers = this.runtimeManagementService.getContainers(instanceKey);
        Assert.assertNotNull((Object)containers);
        Assert.assertEquals((long)1L, (long)containers.size());
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).getContainers((ServerInstanceKey)Matchers.any(ServerInstanceKey.class));
    }
}

