/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.AbstractServiceImplTest;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpecManagementServiceImplTest
extends AbstractServiceImplTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private KieServerTemplateStorage templateStorage;
    @Mock
    private KieServerInstanceManager kieServerInstanceManager;
    @Mock
    private NotificationService notificationService;

    @Before
    public void setup() {
        this.specManagementService = new SpecManagementServiceImpl();
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        specManagementService.setKieServerInstanceManager(this.kieServerInstanceManager);
    }

    @After
    public void cleanup() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
    }

    @Test
    public void testCreateServerTemplate() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        ServerTemplateKey saved = existing.getServerTemplates()[0];
        Assert.assertEquals((Object)serverTemplate.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)saved.getId());
    }

    @Test
    public void testCreateServerTemplateAndContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        ContainerSpecList specs = this.specManagementService.listContainerSpec(serverTemplate.getId());
        Assert.assertNotNull((Object)specs);
        Assert.assertEquals((long)1L, (long)specs.getContainerSpecs().length);
        container = specs.getContainerSpecs()[0];
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
    }

    @Test
    public void testListServerTemplates() {
        int limit = this.getRandomInt(5, 10);
        for (int x = 0; x < limit; ++x) {
            ServerTemplate serverTemplate = new ServerTemplate();
            serverTemplate.setName("test server " + x);
            serverTemplate.setId(UUID.randomUUID().toString());
            this.specManagementService.saveServerTemplate(serverTemplate);
        }
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)limit, (long)existing.getServerTemplates().length);
        ServerTemplateList allTemplates = this.specManagementService.listServerTemplates();
        Assert.assertNotNull((Object)allTemplates);
        Assert.assertEquals((long)limit, (long)allTemplates.getServerTemplates().length);
    }

    @Test
    public void testCreateAndDeleteServerTemplate() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        ServerTemplateKey saved = existing.getServerTemplates()[0];
        Assert.assertEquals((Object)serverTemplate.getName(), (Object)saved.getName());
        Assert.assertEquals((Object)serverTemplate.getId(), (Object)saved.getId());
        this.specManagementService.deleteServerTemplate(serverTemplate.getId());
        existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)0L, (long)existing.getServerTemplates().length);
    }

    @Test
    public void testCreateServerTemplateAndAddRemoveContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        int limit = this.getRandomInt(3, 6);
        for (int x = 0; x < limit; ++x) {
            HashMap configs = new HashMap();
            RuleConfig ruleConfig = new RuleConfig();
            ruleConfig.setPollInterval(Long.valueOf(1000L));
            ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
            ProcessConfig processConfig = new ProcessConfig();
            processConfig.setKBase("defaultKieBase");
            processConfig.setKSession("defaultKieSession");
            processConfig.setMergeMode("MERGE_COLLECTION");
            processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
            ContainerSpec containerSpec = new ContainerSpec();
            containerSpec.setId("test container " + x);
            containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", x + ".0"));
            containerSpec.setStatus(KieContainerStatus.STOPPED);
            containerSpec.setConfigs(configs);
            this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        }
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)limit, (long)createdServerTemplate.getContainersSpec().size());
        this.specManagementService.deleteContainerSpec(serverTemplate.getId(), "test container 0");
        createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)(limit - 1), (long)createdServerTemplate.getContainersSpec().size());
    }

    @Test
    public void testCreateServerTemplateAndCreateThenCopyContainer() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        HashMap configs = new HashMap();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        String newServerTemplateId = "Copied server id";
        String newServerTemplateName = "Copied server name";
        this.specManagementService.copyServerTemplate(serverTemplate.getId(), newServerTemplateId, newServerTemplateName);
        existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)2L, (long)existing.getServerTemplates().length);
        createdServerTemplate = this.specManagementService.getServerTemplate(newServerTemplateId);
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertEquals((Object)newServerTemplateName, (Object)createdServerTemplate.getName());
        Assert.assertEquals((Object)newServerTemplateId, (Object)createdServerTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)newServerTemplateId, (Object)container.getServerTemplateKey().getId());
        Assert.assertEquals((Object)newServerTemplateName, (Object)container.getServerTemplateKey().getName());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
    }

    @Test
    public void testCreateServerTemplateAndUpdateContainerConfig() {
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setName("test server");
        serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(serverTemplate.getId(), containerSpec);
        ServerTemplate createdServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertNotNull((Object)createdServerTemplate);
        Assert.assertNotNull((Object)createdServerTemplate.getContainersSpec());
        Assert.assertEquals((long)1L, (long)createdServerTemplate.getContainersSpec().size());
        ContainerSpec container = (ContainerSpec)createdServerTemplate.getContainersSpec().iterator().next();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        ContainerConfig ruleConfigCurrent = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigCurrent);
        Assert.assertTrue((boolean)(ruleConfigCurrent instanceof RuleConfig));
        Assert.assertEquals((Object)ruleConfig.getPollInterval(), (Object)((RuleConfig)ruleConfigCurrent).getPollInterval());
        Assert.assertEquals((Object)ruleConfig.getScannerStatus(), (Object)((RuleConfig)ruleConfigCurrent).getScannerStatus());
        RuleConfig containerConfig = new RuleConfig();
        containerConfig.setScannerStatus(KieScannerStatus.SCANNING);
        containerConfig.setPollInterval(Long.valueOf(10L));
        this.specManagementService.updateContainerConfig(serverTemplate.getId(), containerSpec.getId(), Capability.RULE, (ContainerConfig)containerConfig);
        ContainerSpecList specs = this.specManagementService.listContainerSpec(serverTemplate.getId());
        Assert.assertNotNull((Object)specs);
        Assert.assertEquals((long)1L, (long)specs.getContainerSpecs().length);
        container = specs.getContainerSpecs()[0];
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerSpec.getId(), (Object)container.getId());
        Assert.assertEquals((Object)containerSpec.getStatus(), (Object)container.getStatus());
        Assert.assertEquals((Object)containerSpec.getServerTemplateKey(), (Object)container.getServerTemplateKey());
        Assert.assertEquals((Object)containerSpec.getReleasedId(), (Object)container.getReleasedId());
        Assert.assertNotNull((Object)container.getConfigs());
        Assert.assertEquals((long)containerSpec.getConfigs().size(), (long)container.getConfigs().size());
        ContainerConfig ruleConfigCurrent2 = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfigCurrent2);
        Assert.assertTrue((boolean)(ruleConfigCurrent2 instanceof RuleConfig));
        Assert.assertEquals((Object)containerConfig.getPollInterval(), (Object)((RuleConfig)ruleConfigCurrent2).getPollInterval());
        Assert.assertEquals((Object)containerConfig.getScannerStatus(), (Object)((RuleConfig)ruleConfigCurrent2).getScannerStatus());
    }

    @Test
    public void testStartContainer() {
        this.createServerTemplateWithContainer();
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.startContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.specManagementService.startContainer((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).startContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Assert.assertNotNull((Object)updated);
        ContainerSpec updatedContainer = updated.getContainerSpec(this.containerSpec.getId());
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertEquals((Object)KieContainerStatus.STARTED, (Object)updatedContainer.getStatus());
    }

    @Test
    public void testStopContainer() {
        this.createServerTemplateWithContainer();
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.stopContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.specManagementService.stopContainer((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).stopContainer((ServerTemplate)Matchers.any(ServerTemplate.class), (ContainerSpec)Matchers.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Assert.assertNotNull((Object)updated);
        ContainerSpec updatedContainer = updated.getContainerSpec(this.containerSpec.getId());
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertEquals((Object)KieContainerStatus.STOPPED, (Object)updatedContainer.getStatus());
    }

    @Test
    public void testUpdateContainerConfigWhenContainerConfigIsARuleConfig() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)Mockito.spy((Object)((SpecManagementServiceImpl)this.specManagementService));
        Capability capability = Capability.RULE;
        RuleConfig ruleConfig = (RuleConfig)Mockito.mock(RuleConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        List expectedContainers = (List)Mockito.mock(List.class);
        ((SpecManagementServiceImpl)Mockito.doReturn((Object)expectedContainers).when((Object)specManagementService)).updateContainerRuleConfig(ruleConfig, serverTemplate, containerSpec);
        List actualContainers = specManagementService.updateContainerConfig(capability, (ContainerConfig)ruleConfig, serverTemplate, containerSpec);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerConfigWhenContainerConfigIsAProcessConfig() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)Mockito.spy((Object)((SpecManagementServiceImpl)this.specManagementService));
        Capability capability = Capability.PROCESS;
        ProcessConfig processConfig = (ProcessConfig)Mockito.mock(ProcessConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        List expectedContainers = (List)Mockito.mock(List.class);
        ((SpecManagementServiceImpl)Mockito.doReturn((Object)expectedContainers).when((Object)specManagementService)).updateContainerProcessConfig(processConfig, capability, serverTemplate, containerSpec);
        List actualContainers = specManagementService.updateContainerConfig(capability, (ContainerConfig)processConfig, serverTemplate, containerSpec);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerConfigWhenServerTemplateIsNull() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        String serverTemplateId = "serverTemplateId";
        String containerSpecId = "containerSpecId";
        Capability capability = Capability.PROCESS;
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        specManagementService.setTemplateStorage(this.templateStorage);
        ((KieServerTemplateStorage)Mockito.doReturn(null).when((Object)this.templateStorage)).load("serverTemplateId");
        this.expectedException.expect(KieServerControllerIllegalArgumentException.class);
        this.expectedException.expectMessage("No server template found for id serverTemplateId");
        specManagementService.updateContainerConfig("serverTemplateId", "containerSpecId", capability, containerConfig);
    }

    @Test
    public void testUpdateContainerConfigWhenContainerSpecIsNull() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        String serverTemplateId = "serverTemplateId";
        String containerSpecId = "containerSpecId";
        Capability capability = Capability.PROCESS;
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        specManagementService.setTemplateStorage(this.templateStorage);
        ((KieServerTemplateStorage)Mockito.doReturn((Object)serverTemplate).when((Object)this.templateStorage)).load("serverTemplateId");
        ((ServerTemplate)Mockito.doReturn(null).when((Object)serverTemplate)).getContainersSpec();
        this.expectedException.expect(KieServerControllerIllegalArgumentException.class);
        this.expectedException.expectMessage("No container spec found for id containerSpecId within server template with id serverTemplateId");
        specManagementService.updateContainerConfig("serverTemplateId", "containerSpecId", capability, containerConfig);
    }

    @Test
    public void testUpdateContainerConfigWhenAffectedContainersIsEmpty() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)Mockito.spy((Object)((SpecManagementServiceImpl)this.specManagementService));
        String serverTemplateId = "serverTemplateId";
        String containerSpecId = "containerSpecId";
        Capability capability = Capability.PROCESS;
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        Map configs = (Map)Mockito.spy(new HashMap());
        ArrayList expectedContainers = new ArrayList();
        specManagementService.setTemplateStorage(this.templateStorage);
        specManagementService.setNotificationService(this.notificationService);
        ((KieServerTemplateStorage)Mockito.doReturn((Object)serverTemplate).when((Object)this.templateStorage)).load("serverTemplateId");
        ((ServerTemplate)Mockito.doReturn((Object)containerSpec).when((Object)serverTemplate)).getContainerSpec("containerSpecId");
        ((SpecManagementServiceImpl)Mockito.doReturn(expectedContainers).when((Object)specManagementService)).updateContainerConfig(capability, containerConfig, serverTemplate, containerSpec);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)containerSpec)).getConfigs();
        specManagementService.updateContainerConfig("serverTemplateId", "containerSpecId", capability, containerConfig);
        ((SpecManagementServiceImpl)Mockito.verify((Object)specManagementService)).logInfo("Update of container configuration resulted in no changes to containers running on kie-servers");
        ((SpecManagementServiceImpl)Mockito.verify((Object)specManagementService, (VerificationMode)Mockito.never())).logDebug((String)Matchers.any(), (Object[])Matchers.any());
        ((Map)Mockito.verify((Object)configs)).put(capability, containerConfig);
        ((KieServerTemplateStorage)Mockito.verify((Object)this.templateStorage)).update(serverTemplate);
        ((NotificationService)Mockito.verify((Object)this.notificationService)).notify((ServerTemplateUpdated)Matchers.any(ServerTemplateUpdated.class));
    }

    @Test
    public void testUpdateContainerConfigWhenAffectedContainersIsNotEmpty() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)Mockito.spy((Object)((SpecManagementServiceImpl)this.specManagementService));
        String serverTemplateId = "serverTemplateId";
        String containerSpecId = "containerSpecId";
        Capability capability = Capability.PROCESS;
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        Map configs = (Map)Mockito.spy(new HashMap());
        final Container container1 = this.makeContainer("1");
        final Container container2 = this.makeContainer("2");
        ArrayList<Container> expectedContainers = new ArrayList<Container>(){
            {
                this.add(container1);
                this.add(container2);
            }
        };
        specManagementService.setTemplateStorage(this.templateStorage);
        specManagementService.setNotificationService(this.notificationService);
        ((KieServerTemplateStorage)Mockito.doReturn((Object)serverTemplate).when((Object)this.templateStorage)).load("serverTemplateId");
        ((ServerTemplate)Mockito.doReturn((Object)containerSpec).when((Object)serverTemplate)).getContainerSpec("containerSpecId");
        ((SpecManagementServiceImpl)Mockito.doReturn((Object)expectedContainers).when((Object)specManagementService)).updateContainerConfig(capability, containerConfig, serverTemplate, containerSpec);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)containerSpec)).getConfigs();
        specManagementService.updateContainerConfig("serverTemplateId", "containerSpecId", capability, containerConfig);
        ((SpecManagementServiceImpl)Mockito.verify((Object)specManagementService)).logDebug("Container {} on server {} was affected by a change in the scanner", new Object[]{container1.getContainerSpecId(), container1.getServerInstanceKey()});
        ((SpecManagementServiceImpl)Mockito.verify((Object)specManagementService)).logDebug("Container {} on server {} was affected by a change in the scanner", new Object[]{container2.getContainerSpecId(), container2.getServerInstanceKey()});
        ((SpecManagementServiceImpl)Mockito.verify((Object)specManagementService, (VerificationMode)Mockito.never())).logInfo((String)Matchers.any());
        ((Map)Mockito.verify((Object)configs)).put(capability, containerConfig);
        ((KieServerTemplateStorage)Mockito.verify((Object)this.templateStorage)).update(serverTemplate);
        ((NotificationService)Mockito.verify((Object)this.notificationService)).notify((ServerTemplateUpdated)Matchers.any(ServerTemplateUpdated.class));
    }

    private Container makeContainer(String seed) {
        Container container = (Container)Mockito.mock(Container.class);
        ((Container)Mockito.doReturn((Object)seed).when((Object)container)).getContainerSpecId();
        ((Container)Mockito.doReturn((Object)Mockito.mock(ServerInstanceKey.class)).when((Object)container)).getServerInstanceKey();
        return container;
    }

    @Test
    public void testUpdateContainerConfigWhenContainerConfigIsNotAProcessConfigNeitherARuleConfig() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)Mockito.spy((Object)((SpecManagementServiceImpl)this.specManagementService));
        Capability capability = Capability.PROCESS;
        ContainerConfig containerConfig = (ContainerConfig)Mockito.mock(ContainerConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        ArrayList expectedContainers = new ArrayList();
        List actualContainers = specManagementService.updateContainerConfig(capability, containerConfig, serverTemplate, containerSpec);
        Assert.assertEquals(expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerProcessConfig() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        ProcessConfig processConfig = (ProcessConfig)Mockito.mock(ProcessConfig.class);
        Capability capability = Capability.PROCESS;
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        Map configs = (Map)Mockito.spy(new HashMap());
        List expectedContainers = (List)Mockito.mock(List.class);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)containerSpec)).getConfigs();
        ((KieServerInstanceManager)Mockito.doReturn((Object)expectedContainers).when((Object)this.kieServerInstanceManager)).upgradeContainer(serverTemplate, containerSpec);
        List actualContainers = specManagementService.updateContainerProcessConfig(processConfig, capability, serverTemplate, containerSpec);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerRuleConfigWhenKieScannerStatusIsStarted() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        RuleConfig ruleConfig = (RuleConfig)Mockito.mock(RuleConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        Long interval = 1L;
        List expectedContainers = (List)Mockito.mock(List.class);
        ((RuleConfig)Mockito.doReturn((Object)interval).when((Object)ruleConfig)).getPollInterval();
        ((RuleConfig)Mockito.doReturn((Object)KieScannerStatus.STARTED).when((Object)ruleConfig)).getScannerStatus();
        ((KieServerInstanceManager)Mockito.doReturn((Object)expectedContainers).when((Object)this.kieServerInstanceManager)).startScanner(serverTemplate, containerSpec, interval.longValue());
        List actualContainers = specManagementService.updateContainerRuleConfig(ruleConfig, serverTemplate, containerSpec);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerRuleConfigWhenKieScannerStatusIsStopped() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        RuleConfig ruleConfig = (RuleConfig)Mockito.mock(RuleConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        List expectedContainers = (List)Mockito.mock(List.class);
        ((RuleConfig)Mockito.doReturn((Object)KieScannerStatus.STOPPED).when((Object)ruleConfig)).getScannerStatus();
        ((KieServerInstanceManager)Mockito.doReturn((Object)expectedContainers).when((Object)this.kieServerInstanceManager)).stopScanner(serverTemplate, containerSpec);
        List actualContainers = specManagementService.updateContainerRuleConfig(ruleConfig, serverTemplate, containerSpec);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testUpdateContainerRuleConfigWhenKieScannerStatusIsNotStartedNeitherStopped() {
        SpecManagementServiceImpl specManagementService = (SpecManagementServiceImpl)this.specManagementService;
        RuleConfig ruleConfig = (RuleConfig)Mockito.mock(RuleConfig.class);
        ServerTemplate serverTemplate = (ServerTemplate)Mockito.mock(ServerTemplate.class);
        ContainerSpec containerSpec = (ContainerSpec)Mockito.mock(ContainerSpec.class);
        ArrayList expectedContainers = new ArrayList();
        ((RuleConfig)Mockito.doReturn((Object)KieScannerStatus.UNKNOWN).when((Object)ruleConfig)).getScannerStatus();
        List actualContainers = specManagementService.updateContainerRuleConfig(ruleConfig, serverTemplate, containerSpec);
        Assert.assertEquals(expectedContainers, (Object)actualContainers);
    }

    protected int getRandomInt(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min + 1)) + min;
    }

    @Test
    public void testDeleteServerInstance() {
        ServerTemplate serverTemplate = new ServerTemplate("serverTemplateId", "serverTemplateName");
        ServerInstanceKey serverInstanceKey = new ServerInstanceKey(serverTemplate.getId(), "serverName", "serverInstanceId", "url");
        serverTemplate.addServerInstance(serverInstanceKey);
        this.specManagementService.saveServerTemplate(serverTemplate);
        Mockito.when((Object)this.kieServerInstanceManager.isAlive(serverInstanceKey)).thenReturn((Object)false);
        this.specManagementService.deleteServerInstance(serverInstanceKey);
        ServerTemplate updatedServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertEquals((long)0L, (long)updatedServerTemplate.getServerInstanceKeys().size());
    }

    @Test
    public void testDeleteServerInstanceAlive() {
        ServerTemplate serverTemplate = new ServerTemplate("serverTemplateId", "serverTemplateName");
        ServerInstanceKey serverInstanceKey = new ServerInstanceKey(serverTemplate.getId(), "serverName", "serverInstanceId", "url");
        serverTemplate.addServerInstance(serverInstanceKey);
        this.specManagementService.saveServerTemplate(serverTemplate);
        Mockito.when((Object)this.kieServerInstanceManager.isAlive(serverInstanceKey)).thenReturn((Object)true);
        try {
            this.specManagementService.deleteServerInstance(serverInstanceKey);
            Assert.fail((String)"Deleting a live server instance should fail");
        }
        catch (Exception ex) {
            Assert.assertEquals((Object)"Can't delete live instance.", (Object)ex.getMessage());
        }
        ServerTemplate updatedServerTemplate = this.specManagementService.getServerTemplate(serverTemplate.getId());
        Assert.assertEquals((long)1L, (long)updatedServerTemplate.getServerInstanceKeys().size());
    }
}

