/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.LoggingNotificationService;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecManagementServiceImpl
implements SpecManagementService {
    private static Logger logger = LoggerFactory.getLogger(SpecManagementServiceImpl.class);
    private KieServerInstanceManager kieServerInstanceManager = KieServerInstanceManager.getInstance();
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private NotificationService notificationService = LoggingNotificationService.getInstance();

    public synchronized void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        if (serverTemplate.hasContainerSpec(containerSpec.getId())) {
            throw new KieServerControllerException("Server template with id " + serverTemplateId + " associated already with container " + containerSpec.getId());
        }
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        serverTemplate.addContainerSpec(containerSpec);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        if (containerSpec.getStatus().equals((Object)KieContainerStatus.STARTED)) {
            List<Container> containers = this.kieServerInstanceManager.startContainer(serverTemplate, containerSpec);
            this.notificationService.notify(serverTemplate, containerSpec, containers);
        }
    }

    public synchronized void updateContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.updateContainerSpec(serverTemplateId, containerSpec.getId(), containerSpec);
    }

    public synchronized void updateContainerSpec(String serverTemplateId, String containerId, ContainerSpec containerSpec) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        if (!containerSpec.getId().equals(containerId)) {
            throw new KieServerControllerException("Cannot update container " + containerSpec.getId() + " on container " + containerId);
        }
        if (!serverTemplate.hasContainerSpec(containerSpec.getId())) {
            throw new KieServerControllerIllegalArgumentException("Server template with id " + serverTemplateId + " has no container with id " + containerSpec.getId());
        }
        if (!serverTemplate.hasMatchingId(containerSpec.getServerTemplateKey())) {
            throw new KieServerControllerException("Cannot change container template key during update.");
        }
        containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
        ContainerSpec currentVersion = serverTemplate.getContainerSpec(containerSpec.getId());
        serverTemplate.deleteContainerSpec(currentVersion.getId());
        serverTemplate.addContainerSpec(containerSpec);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        if (currentVersion.getStatus().equals((Object)KieContainerStatus.STARTED) || containerSpec.getStatus().equals((Object)KieContainerStatus.STARTED)) {
            List<Container> containers = this.kieServerInstanceManager.upgradeAndStartContainer(serverTemplate, containerSpec);
            this.notificationService.notify(serverTemplate, containerSpec, containers);
        }
    }

    public synchronized void saveServerTemplate(ServerTemplate serverTemplate) {
        if (this.templateStorage.exists(serverTemplate.getId())) {
            this.templateStorage.update(serverTemplate);
        } else {
            this.templateStorage.store(serverTemplate);
        }
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        Collection containerSpecs = serverTemplate.getContainersSpec();
        if (containerSpecs != null && !containerSpecs.isEmpty()) {
            for (ContainerSpec containerSpec : containerSpecs) {
                if (!containerSpec.getStatus().equals((Object)KieContainerStatus.STARTED)) continue;
                List<Container> containers = this.kieServerInstanceManager.startContainer(serverTemplate, containerSpec);
                this.notificationService.notify(serverTemplate, containerSpec, containers);
            }
        }
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        return serverTemplate;
    }

    public ServerTemplateKeyList listServerTemplateKeys() {
        return new ServerTemplateKeyList((Collection)this.templateStorage.loadKeys());
    }

    public ServerTemplateList listServerTemplates() {
        return new ServerTemplateList((Collection)this.templateStorage.load());
    }

    public ContainerSpecList listContainerSpec(String serverTemplateId) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        return new ContainerSpecList(serverTemplate.getContainersSpec());
    }

    public ContainerSpec getContainerInfo(String serverTemplateId, String containerId) {
        ServerTemplate serverTemplate = this.getServerTemplate(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("Server template " + serverTemplateId + " does not have container with id " + containerId);
        }
        return containerSpec;
    }

    public synchronized void deleteContainerSpec(String serverTemplateId, String containerSpecId) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        if (!serverTemplate.hasContainerSpec(containerSpecId)) {
            throw new KieServerControllerIllegalArgumentException("Container " + containerSpecId + " not found");
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecId);
        this.kieServerInstanceManager.stopContainer(serverTemplate, containerSpec);
        serverTemplate.deleteContainerSpec(containerSpecId);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
    }

    public synchronized void deleteServerTemplate(String serverTemplateId) {
        if (!this.templateStorage.exists(serverTemplateId)) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        this.templateStorage.delete(serverTemplateId);
        this.notificationService.notify(new ServerTemplateDeleted(serverTemplateId));
    }

    public synchronized void copyServerTemplate(String serverTemplateId, String newServerTemplateId, String newServerTemplateName) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        HashMap configMap = new HashMap(serverTemplate.getConfigs().size());
        for (Map.Entry entry : serverTemplate.getConfigs().entrySet()) {
            configMap.put(entry.getKey(), this.copy((ServerConfig)entry.getValue()));
        }
        ArrayList<ContainerSpec> containerSpecs = new ArrayList<ContainerSpec>(serverTemplate.getContainersSpec().size());
        for (ContainerSpec entry : serverTemplate.getContainersSpec()) {
            containerSpecs.add(this.copy(entry, newServerTemplateId, newServerTemplateName));
        }
        ServerTemplate serverTemplate2 = new ServerTemplate(newServerTemplateId, newServerTemplateName, (Collection)serverTemplate.getCapabilities(), configMap, containerSpecs);
        this.templateStorage.store(serverTemplate2);
    }

    private ContainerSpec copy(ContainerSpec origin, String newServerTemplateId, String newServerTemplateName) {
        Map configMap = origin.getConfigs();
        for (Map.Entry entry : origin.getConfigs().entrySet()) {
            configMap.put(entry.getKey(), this.copy((ContainerConfig)entry.getValue()));
        }
        return new ContainerSpec(origin.getId(), origin.getContainerName(), new ServerTemplateKey(newServerTemplateId, newServerTemplateName), new ReleaseId((org.kie.api.builder.ReleaseId)origin.getReleasedId()), origin.getStatus(), configMap);
    }

    private ContainerConfig copy(ContainerConfig _value) {
        if (_value instanceof RuleConfig) {
            RuleConfig value = (RuleConfig)_value;
            return new RuleConfig(value.getPollInterval(), value.getScannerStatus());
        }
        if (_value instanceof ProcessConfig) {
            ProcessConfig value = (ProcessConfig)_value;
            return new ProcessConfig(value.getRuntimeStrategy(), value.getKBase(), value.getKSession(), value.getMergeMode());
        }
        return null;
    }

    private ServerConfig copy(ServerConfig value) {
        return new ServerConfig();
    }

    public synchronized void updateContainerConfig(String serverTemplateId, String containerSpecId, Capability capability, ContainerConfig containerConfig) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecId);
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecId + " within server template with id " + serverTemplateId);
        }
        List<Container> affectedContainers = this.updateContainerConfig(capability, containerConfig, serverTemplate, containerSpec);
        if (affectedContainers.isEmpty()) {
            this.logInfo("Update of container configuration resulted in no changes to containers running on kie-servers");
        }
        affectedContainers.forEach(ac -> this.logDebug("Container {} on server {} was affected by a change in the scanner", ac.getContainerSpecId(), ac.getServerInstanceKey()));
        containerSpec.getConfigs().put(capability, containerConfig);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
    }

    void logInfo(String message) {
        logger.info(message);
    }

    void logDebug(String message, Object ... objects) {
        logger.debug(message, objects);
    }

    List<Container> updateContainerConfig(Capability capability, ContainerConfig containerConfig, ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        if (containerConfig instanceof RuleConfig) {
            RuleConfig ruleConfig = (RuleConfig)containerConfig;
            return this.updateContainerRuleConfig(ruleConfig, serverTemplate, containerSpec);
        }
        if (containerConfig instanceof ProcessConfig) {
            ProcessConfig processConfig = (ProcessConfig)containerConfig;
            return this.updateContainerProcessConfig(processConfig, capability, serverTemplate, containerSpec);
        }
        return new ArrayList<Container>();
    }

    List<Container> updateContainerProcessConfig(ProcessConfig processConfig, Capability capability, ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        containerSpec.getConfigs().put(capability, processConfig);
        return this.kieServerInstanceManager.upgradeContainer(serverTemplate, containerSpec);
    }

    List<Container> updateContainerRuleConfig(RuleConfig ruleConfig, ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        Long interval = ruleConfig.getPollInterval();
        KieScannerStatus status = ruleConfig.getScannerStatus();
        switch (status) {
            case STARTED: {
                return this.kieServerInstanceManager.startScanner(serverTemplate, containerSpec, interval);
            }
            case STOPPED: {
                return this.kieServerInstanceManager.stopScanner(serverTemplate, containerSpec);
            }
        }
        return new ArrayList<Container>();
    }

    public synchronized void updateServerTemplateConfig(String serverTemplateId, Capability capability, ServerConfig serverTemplateConfig) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        Map configs = serverTemplate.getConfigs();
        configs.put(capability, serverTemplateConfig);
        serverTemplate.setConfigs(configs);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
    }

    public synchronized void startContainer(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId() + " within server template with id " + serverTemplate.getId());
        }
        containerSpec.setStatus(KieContainerStatus.STARTED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.startContainer(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public synchronized void stopContainer(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId() + " within server template with id " + serverTemplate.getId());
        }
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.stopContainer(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public synchronized void activateContainer(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId() + " within server template with id " + serverTemplate.getId());
        }
        if (!containerSpec.getStatus().equals((Object)KieContainerStatus.DEACTIVATED)) {
            throw new KieServerControllerIllegalArgumentException("Container " + containerSpecKey.getId() + " cannot be activated because it's not in deactivated state, actual state " + containerSpec.getStatus());
        }
        containerSpec.setStatus(KieContainerStatus.STARTED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.activateContainer(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public synchronized void deactivateContainer(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId() + " within server template with id " + serverTemplate.getId());
        }
        if (!containerSpec.getStatus().equals((Object)KieContainerStatus.STARTED)) {
            throw new KieServerControllerIllegalArgumentException("Container " + containerSpecKey.getId() + " cannot be deactivated because it's not in started state, actual state " + containerSpec.getStatus());
        }
        containerSpec.setStatus(KieContainerStatus.DEACTIVATED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.deactivateContainer(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public void deleteServerInstance(ServerInstanceKey serverInstanceKey) {
        PortablePreconditions.checkNotNull((String)"serverInstanceKey", (Object)serverInstanceKey);
        if (this.getKieServerInstanceManager().isAlive(serverInstanceKey)) {
            throw new RuntimeException("Can't delete live instance.");
        }
        String serverInstanceId = serverInstanceKey.getServerInstanceId();
        ServerTemplate serverTemplate = this.getServerTemplate(serverInstanceKey.getServerTemplateId());
        if (serverTemplate != null) {
            serverTemplate.deleteServerInstance(serverInstanceId);
            this.getTemplateStorage().update(serverTemplate);
            this.getNotificationService().notify(new ServerInstanceDeleted(serverInstanceId));
        }
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public KieServerInstanceManager getKieServerInstanceManager() {
        return this.kieServerInstanceManager;
    }

    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        this.kieServerInstanceManager = kieServerInstanceManager;
    }
}

