/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.List;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.LoggingNotificationService;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;

public class RuleCapabilitiesServiceImpl
implements RuleCapabilitiesService {
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private KieServerInstanceManager kieServerInstanceManager = KieServerInstanceManager.getInstance();
    private NotificationService notificationService = LoggingNotificationService.getInstance();

    public void scanNow(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId());
        }
        List<Container> containers = this.kieServerInstanceManager.scanNow(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public void startScanner(ContainerSpecKey containerSpecKey, Long interval) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId());
        }
        ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        if (containerConfig == null) {
            containerConfig = new RuleConfig();
            containerSpec.getConfigs().put(Capability.RULE, containerConfig);
        }
        ((RuleConfig)containerConfig).setPollInterval(interval);
        ((RuleConfig)containerConfig).setScannerStatus(KieScannerStatus.STARTED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.startScanner(serverTemplate, containerSpec, interval);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public void stopScanner(ContainerSpecKey containerSpecKey) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId());
        }
        ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        if (containerConfig == null) {
            containerConfig = new RuleConfig();
            containerSpec.getConfigs().put(Capability.RULE, containerConfig);
        }
        if (((RuleConfig)containerConfig).getScannerStatus() == KieScannerStatus.STOPPED) {
            return;
        }
        ((RuleConfig)containerConfig).setPollInterval(null);
        ((RuleConfig)containerConfig).setScannerStatus(KieScannerStatus.STOPPED);
        this.templateStorage.update(serverTemplate);
        List<Container> containers = this.kieServerInstanceManager.stopScanner(serverTemplate, containerSpec);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public void upgradeContainer(ContainerSpecKey containerSpecKey, ReleaseId releaseId) {
        ServerTemplate serverTemplate = this.templateStorage.load(containerSpecKey.getServerTemplateKey().getId());
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + containerSpecKey.getServerTemplateKey().getId());
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecKey.getId());
        if (containerSpec == null) {
            throw new KieServerControllerIllegalArgumentException("No container spec found for id " + containerSpecKey.getId());
        }
        if (releaseId.getGroupId() == null) {
            releaseId.setGroupId(containerSpec.getReleasedId().getGroupId());
        }
        if (releaseId.getArtifactId() == null) {
            releaseId.setArtifactId(containerSpec.getReleasedId().getArtifactId());
        }
        containerSpec.setReleasedId(releaseId);
        List<Container> containers = containerSpec.getStatus() == KieContainerStatus.STARTED ? this.kieServerInstanceManager.upgradeContainer(serverTemplate, containerSpec) : this.kieServerInstanceManager.startContainer(serverTemplate, containerSpec);
        containerSpec.setStatus(KieContainerStatus.STARTED);
        this.templateStorage.update(serverTemplate);
        this.notificationService.notify(serverTemplate, containerSpec, containers);
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public KieServerInstanceManager getKieServerInstanceManager() {
        return this.kieServerInstanceManager;
    }

    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        this.kieServerInstanceManager = kieServerInstanceManager;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

