/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;

public class KieServerControllerImplTest {
    private static final String DEFAULT_SERVER_TEMPLATE_ID = "templateId";
    private static final String DEFAULT_SERVER_TEMPLATE_NAME = "templateName";
    private static final String DEFAULT_KIE_SERVER_ID = "templateId";
    private static final String DEFAULT_KIE_SERVER_LOCATION = "http://some-random-location.com";
    private KieServerControllerImpl controller = new KieServerControllerImpl(){};

    @After
    public void cleanup() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
    }

    @Test
    public void testConnectWithAllCapabilities() {
        this.storeDefaultServerTemplate(Capability.RULE, Capability.PROCESS, Capability.PLANNING);
        KieServerInfo kieServerInfo = this.createDefaultKieServerInfo("BRM", "BPM", "BRP");
        KieServerSetup kieServerSetup = this.controller.connect(kieServerInfo);
        Assert.assertTrue((boolean)kieServerSetup.hasNoErrors());
        Assert.assertTrue((boolean)this.controller.getTemplateStorage().load("templateId").hasServerInstance(DEFAULT_KIE_SERVER_LOCATION));
    }

    @Test
    public void testConnectServerTemplateMissingProcessCapability() {
        this.storeDefaultServerTemplate(Capability.RULE, Capability.PLANNING);
        KieServerInfo kieServerInfo = this.createDefaultKieServerInfo("BRM", "BPM", "BRP");
        KieServerSetup kieServerSetup = this.controller.connect(kieServerInfo);
        Assert.assertTrue((boolean)kieServerSetup.hasNoErrors());
        Assert.assertTrue((boolean)this.controller.getTemplateStorage().load("templateId").hasServerInstance(DEFAULT_KIE_SERVER_LOCATION));
    }

    @Test
    public void testConnectKieServerMissingProcessCapability() {
        this.storeDefaultServerTemplate(Capability.RULE, Capability.PROCESS, Capability.PLANNING);
        KieServerInfo kieServerInfo = this.createDefaultKieServerInfo("BRM", "BRP");
        KieServerSetup kieServerSetup = this.controller.connect(kieServerInfo);
        Assert.assertFalse((boolean)kieServerSetup.hasNoErrors());
        Assert.assertEquals((long)1L, (long)kieServerSetup.getMessages().size());
        Assert.assertEquals((Object)Severity.ERROR, (Object)((Message)kieServerSetup.getMessages().iterator().next()).getSeverity());
        Assert.assertEquals((Object)"Expected capabilities were [RULE, PROCESS, PLANNING]", ((Message)kieServerSetup.getMessages().iterator().next()).getMessages().iterator().next());
        Assert.assertFalse((boolean)this.controller.getTemplateStorage().load("templateId").hasServerInstance(DEFAULT_KIE_SERVER_LOCATION));
    }

    private void storeDefaultServerTemplate(Capability ... capabilities) {
        List capabilitiesAsString = Arrays.asList(capabilities).stream().map(Enum::toString).collect(Collectors.toList());
        ServerTemplate serverTemplate = new ServerTemplate("templateId", DEFAULT_SERVER_TEMPLATE_NAME);
        serverTemplate.setCapabilities(capabilitiesAsString);
        this.controller.getTemplateStorage().store(serverTemplate);
    }

    private KieServerInfo createDefaultKieServerInfo(String ... capabilities) {
        KieServerInfo kieServerInfo = new KieServerInfo();
        kieServerInfo.setServerId("templateId");
        kieServerInfo.setLocation(DEFAULT_KIE_SERVER_LOCATION);
        kieServerInfo.setCapabilities(Arrays.asList(capabilities));
        return kieServerInfo;
    }
}

