/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.impl.storage.FileBasedKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedKieServerTemplateStorageTest {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedKieServerTemplateStorageTest.class);
    private static final File TEST_SERVER_TEMPLATE_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    private static Map<ServerTemplateKey, ServerTemplate> templateMap;
    private File tmpTemplateStore;
    private FileBasedKieServerTemplateStorage storage;

    private static ServerTemplate createServerTemplateWithContainer(String templateName, int templateCount) {
        ServerTemplate template = new ServerTemplate();
        template.setName(templateName);
        template.setId(UUID.randomUUID().toString());
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        ContainerSpec containerSpec = new ContainerSpec();
        containerSpec.setId("test container");
        containerSpec.setServerTemplateKey(new ServerTemplateKey(template.getId(), template.getName()));
        containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        containerSpec.setConfigs(configs);
        containerSpec.setServerTemplateKey(new ServerTemplateKey(template.getId(), template.getName()));
        template.addContainerSpec(containerSpec);
        Container container = new Container();
        container.setServerInstanceId(template.getId());
        container.setServerTemplateId(template.getId());
        container.setResolvedReleasedId(containerSpec.getReleasedId());
        container.setContainerName(containerSpec.getContainerName());
        container.setContainerSpecId(containerSpec.getId());
        container.setUrl("http://fake.server.net/kie-server");
        container.setStatus(containerSpec.getStatus());
        return template;
    }

    private ServerTemplate getFirstTemplateFromMap() {
        Iterator<ServerTemplate> iter = templateMap.values().iterator();
        ServerTemplate testTemplate = iter.hasNext() ? iter.next() : null;
        Assert.assertNotNull((String)"Unable to find a test server template!", (Object)testTemplate);
        return testTemplate;
    }

    private ServerTemplate loadTemplateWithAssertEquals(ServerTemplate template) {
        ServerTemplate loadedTemplate = this.storage.load(template.getId());
        Assert.assertNotNull((String)"Unable to load template from storage", (Object)loadedTemplate);
        Assert.assertEquals((String)"Loaded template is not the one asked for", (Object)template, (Object)loadedTemplate);
        return loadedTemplate;
    }

    @BeforeClass
    public static void beforeClass() {
        templateMap = Maps.newConcurrentMap();
        for (int x = 0; x < 3; ++x) {
            StringBuilder templateName = new StringBuilder("test server : ").append(x);
            ServerTemplate template = FileBasedKieServerTemplateStorageTest.createServerTemplateWithContainer(templateName.toString(), x + 1);
            ServerTemplateKey key = new ServerTemplateKey(template.getId(), template.getName());
            templateMap.put(key, template);
        }
    }

    @Before
    public void setup() throws IOException {
        this.tmpTemplateStore = File.createTempFile("templates_", ".xml", TEST_SERVER_TEMPLATE_DIRECTORY);
        this.storage = new FileBasedKieServerTemplateStorage(this.tmpTemplateStore.getAbsolutePath());
        templateMap.keySet().forEach(key -> this.storage.store(templateMap.get(key)));
        Assert.assertEquals((String)"Mismatched number of server templates stored", (long)templateMap.keySet().size(), (long)this.storage.loadKeys().size());
    }

    @After
    public void clean() {
        try {
            Files.deleteIfExists(this.tmpTemplateStore.toPath());
        }
        catch (IOException e) {
            logger.warn("Exception while deleting test server template storage", (Throwable)e);
            e.printStackTrace();
        }
    }

    @Test
    public void testStore() {
        this.storage.reloadTemplateMaps();
        Assert.assertEquals((String)"Mismatched number of server templates", (long)templateMap.keySet().size(), (long)this.storage.loadKeys().size());
    }

    @Test
    public void testLoadKeys() {
        this.storage.reloadTemplateMaps();
        List keys = this.storage.loadKeys();
        Assert.assertEquals((String)"Mismatched number of server template keys", (long)templateMap.keySet().size(), (long)keys.size());
        templateMap.keySet().forEach(key -> Assert.assertTrue((String)"Key for server template not found", (boolean)keys.contains(key)));
    }

    @Test
    public void testLoadList() {
        this.storage.reloadTemplateMaps();
        List templates = this.storage.load();
        Assert.assertEquals((String)"Mismatched number of server templates", (long)templateMap.values().size(), (long)templates.size());
        templateMap.values().forEach(value -> Assert.assertTrue((String)"Server template not found", (boolean)templates.contains(value)));
    }

    @Test
    public void testLoadSingle() {
        this.storage.reloadTemplateMaps();
        ServerTemplate toSearchFor = this.getFirstTemplateFromMap();
        this.loadTemplateWithAssertEquals(toSearchFor);
    }

    @Test
    public void testLoadNotExisting() {
        this.storage.reloadTemplateMaps();
        String notExists = "not-exists";
        ServerTemplate loadedTemplate = this.storage.load(notExists);
        Assert.assertNull((Object)loadedTemplate);
    }

    @Test
    public void testExists() {
        this.storage.reloadTemplateMaps();
        ServerTemplate toSearchFor = this.getFirstTemplateFromMap();
        Assert.assertTrue((String)"Exists fails", (boolean)this.storage.exists(toSearchFor.getId()));
    }

    @Test
    public void testNotExists() {
        this.storage.reloadTemplateMaps();
        String notExists = "not-exists";
        Assert.assertFalse((String)("Exists return true for not existing id: " + notExists), (boolean)this.storage.exists(notExists));
    }

    @Test
    public void testUpdate() {
        String testName = "Updated template Name";
        this.storage.reloadTemplateMaps();
        ServerTemplate toUpdateTemplate = this.getFirstTemplateFromMap();
        toUpdateTemplate.setName("Updated template Name");
        this.storage.update(toUpdateTemplate);
        this.storage.reloadTemplateMaps();
        this.loadTemplateWithAssertEquals(toUpdateTemplate);
    }

    @Test
    public void testDelete() {
        this.storage.clearTemplateMaps();
        ServerTemplate toDeleteTemplate = this.getFirstTemplateFromMap();
        this.storage.delete(toDeleteTemplate.getId());
        this.storage.clearTemplateMaps();
        Assert.assertTrue((String)"Delete template failed", (!this.storage.exists(toDeleteTemplate.getId()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNotExistingTemplate() {
        this.storage.reloadTemplateMaps();
        List templates = this.storage.load();
        Assert.assertEquals((String)"Mismatched number of server templates", (long)templateMap.values().size(), (long)templates.size());
        this.storage.delete("not-exists");
        this.storage.reloadTemplateMaps();
        templates = this.storage.load();
        Assert.assertEquals((String)"Mismatched number of server templates", (long)templateMap.values().size(), (long)templates.size());
    }

    @Test
    public void testGetStorageLocation() {
        String location = this.storage.getTemplatesLocation();
        Assert.assertEquals((Object)this.tmpTemplateStore.getAbsolutePath(), (Object)location);
    }
}

