/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.client.KieServicesClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerInstanceManager {
    private static final Logger logger = LoggerFactory.getLogger(KieServerInstanceManager.class);
    private static final String CONTAINERS_URI_PART = "/containers/";
    private static KieServerInstanceManager INSTANCE = new KieServerInstanceManager();
    private List<KieServicesClientProvider> clientProviders = new ArrayList<KieServicesClientProvider>();

    public KieServerInstanceManager() {
        ServiceLoader<KieServicesClientProvider> loader = ServiceLoader.load(KieServicesClientProvider.class);
        loader.forEach(provider -> this.clientProviders.add((KieServicesClientProvider)provider));
        this.clientProviders.sort((one, two) -> one.getPriority().compareTo(two.getPriority()));
    }

    public static KieServerInstanceManager getInstance() {
        return INSTANCE;
    }

    public List<Container> startScanner(ServerTemplate serverTemplate, final ContainerSpec containerSpec, final long interval) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(Long.valueOf(interval));
                scannerResource.setStatus(KieScannerStatus.STARTED);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner failed to start on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> stopScanner(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(null);
                scannerResource.setStatus(KieScannerStatus.STOPPED);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner failed to stop on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> scanNow(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(null);
                scannerResource.setStatus(KieScannerStatus.SCANNING);
                ServiceResponse response = client.updateScanner(containerSpec.getId(), scannerResource);
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Scanner (scan now) failed on server instance {} due to {}", (Object)container.getUrl(), (Object)response.getMsg());
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public synchronized List<Container> startContainer(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        RemoteKieServerOperation<Void> startContainerOperation = this.makeStartContainerOperation(containerSpec);
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, startContainerOperation);
    }

    RemoteKieServerOperation<Void> makeStartContainerOperation(final ContainerSpec containerSpec) {
        return new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieContainerResource resource = KieServerInstanceManager.this.makeContainerResource(container, containerSpec);
                ServiceResponse response = client.createContainer(containerSpec.getId(), resource);
                if (response.getType() != ServiceResponse.ResponseType.SUCCESS) {
                    KieServerInstanceManager.this.log("Container {} failed to start on server instance {} due to {}", container, response, containerSpec);
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        };
    }

    void log(String message, Object ... objects) {
        logger.debug(message, objects);
    }

    KieContainerResource makeContainerResource(Container container, ContainerSpec containerSpec) {
        KieContainerResource containerResource = new KieContainerResource(containerSpec.getId(), containerSpec.getReleasedId(), container.getResolvedReleasedId(), container.getStatus());
        containerResource.setContainerAlias(containerSpec.getContainerName());
        containerResource.setMessages((List)container.getMessages());
        if (containerSpec.getConfigs() != null) {
            this.setRuleConfigAttributes(containerSpec, containerResource);
            this.setProcessConfigAttributes(containerSpec, containerResource);
        }
        return containerResource;
    }

    KieServerConfigItem makeKieServerConfigItem(String type, String name, String value) {
        KieServerConfigItem configItem = new KieServerConfigItem();
        configItem.setType(type);
        configItem.setName(name);
        configItem.setValue(value);
        return configItem;
    }

    void setRuleConfigAttributes(ContainerSpec containerSpec, KieContainerResource containerResource) {
        ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        if (containerConfig != null) {
            RuleConfig ruleConfig = (RuleConfig)containerConfig;
            KieScannerResource scannerResource = new KieScannerResource();
            scannerResource.setPollInterval(ruleConfig.getPollInterval());
            scannerResource.setStatus(ruleConfig.getScannerStatus());
            containerResource.setScanner(scannerResource);
        }
    }

    void setProcessConfigAttributes(ContainerSpec containerSpec, KieContainerResource containerResource) {
        ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.PROCESS);
        if (containerConfig != null) {
            ProcessConfig processConfig = (ProcessConfig)containerConfig;
            containerResource.addConfigItem(this.makeKieServerConfigItem("BPM", "KBase", processConfig.getKBase()));
            containerResource.addConfigItem(this.makeKieServerConfigItem("BPM", "KSession", processConfig.getKSession()));
            containerResource.addConfigItem(this.makeKieServerConfigItem("BPM", "MergeMode", processConfig.getMergeMode()));
            containerResource.addConfigItem(this.makeKieServerConfigItem("BPM", "RuntimeStrategy", processConfig.getRuntimeStrategy()));
        }
    }

    public synchronized List<Container> stopContainer(ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response = client.disposeContainer(containerSpec.getId());
                if (!response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    logger.debug("Container {} failed to stop on server instance {} due to {}", new Object[]{containerSpec.getId(), container.getUrl(), response.getMsg()});
                }
                KieServerInstanceManager.this.collectContainerInfo(containerSpec, client, container);
                return null;
            }
        });
    }

    public List<Container> upgradeContainer(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, this.makeUpgradeContainerOperation(containerSpec));
    }

    public List<Container> upgradeAndStartContainer(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, this.makeUpgradeAndStartContainerOperation(containerSpec));
    }

    RemoteKieServerOperation<Void> makeUpgradeContainerOperation(final ContainerSpec containerSpec) {
        return new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieServerInstanceManager.this.remoteUpgradeContainer(client, container, containerSpec);
                return null;
            }
        };
    }

    RemoteKieServerOperation<Void> makeUpgradeAndStartContainerOperation(final ContainerSpec containerSpec) {
        return new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                KieContainerResource containerResource = KieServerInstanceManager.this.makeContainerResource(container, containerSpec);
                KieServerInstanceManager.this.remoteCreateContainer(client, containerResource, containerSpec);
                KieServerInstanceManager.this.remoteUpgradeContainer(client, container, containerSpec);
                return null;
            }
        };
    }

    private void remoteCreateContainer(KieServicesClient client, KieContainerResource containerResource, ContainerSpec containerSpec) {
        client.createContainer(containerSpec.getId(), containerResource);
    }

    private void remoteUpgradeContainer(KieServicesClient client, Container container, ContainerSpec containerSpec) {
        ServiceResponse response = client.updateReleaseId(containerSpec.getId(), containerSpec.getReleasedId());
        if (response.getType() != ServiceResponse.ResponseType.SUCCESS) {
            this.log("Container {} failed to upgrade on server instance {} due to {}", containerSpec.getId(), container.getUrl(), response.getMsg());
        }
        this.collectContainerInfo(containerSpec, client, container);
    }

    public List<Container> getContainers(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        RemoteKieServerOperation<Void> operation = this.getContainersRemoteOperation(serverTemplate, containerSpec);
        return this.callRemoteKieServerOperation(serverTemplate, containerSpec, operation);
    }

    RemoteKieServerOperation<Void> getContainersRemoteOperation(final ServerTemplate serverTemplate, final ContainerSpec containerSpec) {
        return new RemoteKieServerOperation<Void>(){

            @Override
            public Void doOperation(KieServicesClient client, Container container) {
                ServiceResponse response = client.getContainerInfo(containerSpec.getId());
                KieContainerResource containerResource = (KieContainerResource)response.getResult();
                if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    container.setContainerSpecId(containerResource.getContainerId());
                    container.setContainerName(containerResource.getContainerId());
                    container.setResolvedReleasedId(containerResource.getResolvedReleaseId() == null ? containerResource.getReleaseId() : containerResource.getResolvedReleaseId());
                    container.setServerTemplateId(serverTemplate.getId());
                    container.setStatus(containerResource.getStatus());
                    container.setMessages((Collection)containerResource.getMessages());
                }
                return null;
            }
        };
    }

    public List<Container> getContainers(ServerInstanceKey serverInstanceKey) {
        ArrayList<Container> containers = new ArrayList<Container>();
        if (serverInstanceKey == null || serverInstanceKey.getUrl() == null) {
            return containers;
        }
        try {
            KieServicesClient client = this.getClient(serverInstanceKey.getUrl());
            ServiceResponse response = client.listContainers();
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                KieContainerResourceList resourceList = (KieContainerResourceList)response.getResult();
                for (KieContainerResource containerResource : resourceList.getContainers()) {
                    Container container = new Container();
                    container.setContainerSpecId(containerResource.getContainerId());
                    container.setContainerName(containerResource.getContainerId());
                    container.setServerInstanceId(serverInstanceKey.getServerInstanceId());
                    container.setUrl(serverInstanceKey.getUrl() + CONTAINERS_URI_PART + containerResource.getContainerId());
                    container.setResolvedReleasedId(containerResource.getResolvedReleaseId() == null ? containerResource.getReleaseId() : containerResource.getResolvedReleaseId());
                    container.setServerTemplateId(serverInstanceKey.getServerTemplateId());
                    container.setStatus(containerResource.getStatus());
                    container.setMessages((Collection)containerResource.getMessages());
                    containers.add(container);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get list of containers from remote server at url {} due to {}", (Object)serverInstanceKey.getUrl(), (Object)e.getMessage());
        }
        return containers;
    }

    protected List<Container> callRemoteKieServerOperation(ServerTemplate serverTemplate, ContainerSpec containerSpec, RemoteKieServerOperation operation) {
        ArrayList<Container> containers = new ArrayList<Container>();
        if (serverTemplate.getServerInstanceKeys() == null || serverTemplate.getServerInstanceKeys().isEmpty() || containerSpec == null) {
            return containers;
        }
        for (ServerInstanceKey instanceUrl : serverTemplate.getServerInstanceKeys()) {
            Container container = new Container();
            container.setContainerSpecId(containerSpec.getId());
            container.setServerTemplateId(serverTemplate.getId());
            container.setServerInstanceId(instanceUrl.getServerInstanceId());
            container.setUrl(instanceUrl.getUrl() + CONTAINERS_URI_PART + containerSpec.getId());
            container.setResolvedReleasedId(containerSpec.getReleasedId());
            container.setStatus(containerSpec.getStatus());
            try {
                KieServicesClient client = this.getClient(instanceUrl.getUrl());
                operation.doOperation(client, container);
            }
            catch (Exception e) {
                logger.debug("Unable to connect to {}", (Object)instanceUrl);
            }
            containers.add(container);
        }
        return containers;
    }

    public boolean isAlive(ServerInstanceKey serverInstanceKey) {
        boolean alive = false;
        try {
            this.getClient(serverInstanceKey.getUrl());
            alive = true;
        }
        catch (Exception e) {
            logger.debug("Unable to connect to server instance at {} due to {}", (Object)serverInstanceKey.getUrl(), (Object)e.getMessage());
        }
        return alive;
    }

    protected KieServicesClient getClient(String url) {
        KieServicesClient client = this.clientProviders.stream().filter(provider -> provider.supports(url)).findFirst().get().get(url);
        logger.debug("Using client {}", (Object)client);
        return client;
    }

    protected void collectContainerInfo(ContainerSpec containerSpec, KieServicesClient client, Container container) {
        ServiceResponse serviceResponse = client.getContainerInfo(containerSpec.getId());
        if (serviceResponse.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
            KieContainerResource containerResource = (KieContainerResource)serviceResponse.getResult();
            container.setMessages((Collection)containerResource.getMessages());
        }
    }

    protected class RemoteKieServerOperation<T> {
        protected RemoteKieServerOperation() {
        }

        public T doOperation(KieServicesClient client, Container container) {
            return null;
        }
    }
}

