/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.HashMap;
import java.util.UUID;
import org.junit.Assert;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.service.RuleCapabilitiesService;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.service.SpecManagementService;
import org.kie.server.controller.impl.KieServerInstanceManager;

public abstract class AbstractServiceImplTest {
    protected SpecManagementService specManagementService;
    protected RuleCapabilitiesService ruleCapabilitiesService;
    protected RuntimeManagementService runtimeManagementService;
    protected KieServerInstanceManager kieServerInstanceManager;
    protected ServerTemplate serverTemplate;
    protected Container container;
    protected ContainerSpec containerSpec;

    protected void createServerTemplateWithContainer() {
        this.serverTemplate = new ServerTemplate();
        this.serverTemplate.setName("test server");
        this.serverTemplate.setId(UUID.randomUUID().toString());
        this.specManagementService.saveServerTemplate(this.serverTemplate);
        ServerTemplateKeyList existing = this.specManagementService.listServerTemplateKeys();
        Assert.assertNotNull((Object)existing);
        Assert.assertEquals((long)1L, (long)existing.getServerTemplates().length);
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        RuleConfig ruleConfig = new RuleConfig();
        ruleConfig.setPollInterval(Long.valueOf(1000L));
        ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, ruleConfig);
        ProcessConfig processConfig = new ProcessConfig();
        processConfig.setKBase("defaultKieBase");
        processConfig.setKSession("defaultKieSession");
        processConfig.setMergeMode("MERGE_COLLECTION");
        processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, processConfig);
        this.containerSpec = new ContainerSpec();
        this.containerSpec.setId("test container");
        this.containerSpec.setServerTemplateKey(new ServerTemplateKey(this.serverTemplate.getId(), this.serverTemplate.getName()));
        this.containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        this.containerSpec.setStatus(KieContainerStatus.STOPPED);
        this.containerSpec.setConfigs(configs);
        this.specManagementService.saveContainerSpec(this.serverTemplate.getId(), this.containerSpec);
        this.serverTemplate = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        this.container = new Container();
        this.container.setServerInstanceId(this.serverTemplate.getId());
        this.container.setServerTemplateId(this.serverTemplate.getId());
        this.container.setResolvedReleasedId(this.containerSpec.getReleasedId());
        this.container.setContainerName(this.containerSpec.getContainerName());
        this.container.setContainerSpecId(this.containerSpec.getId());
        this.container.setUrl("http://fake.server.net/kie-server");
        this.container.setStatus(this.containerSpec.getStatus());
    }
}

