/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;

public abstract class ServerTemplateStorageTest {
    protected KieServerTemplateStorage templateStorage;
    protected ServerTemplate serverTemplate;
    private Container container;
    private ContainerSpec containerSpec;
    private RuleConfig ruleConfig;
    private ProcessConfig processConfig;

    @Test
    public void testStoreServerTemplate() {
        this.templateStorage.store(this.serverTemplate);
        boolean exists = this.templateStorage.exists(this.serverTemplate.getId());
        Assert.assertTrue((boolean)exists);
        ServerTemplate fromStorage = this.templateStorage.load(this.serverTemplate.getId());
        Assert.assertNotNull((Object)fromStorage);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)fromStorage.getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.serverTemplate.getName(), (Object)fromStorage.getName());
        }
        this.checkTemplateInstances(fromStorage);
        Collection containerSpecs = fromStorage.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec spec = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)spec);
        Assert.assertEquals((Object)this.containerSpec.getId(), (Object)spec.getId());
        Assert.assertEquals((Object)this.containerSpec.getReleasedId(), (Object)spec.getReleasedId());
        Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getId(), (Object)spec.getServerTemplateKey().getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getName(), (Object)spec.getServerTemplateKey().getName());
        }
        Assert.assertEquals((long)this.containerSpec.getConfigs().size(), (long)spec.getConfigs().size());
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.RULE));
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.PROCESS));
        RuleConfig ruleConfig = (RuleConfig)spec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfig);
        Assert.assertEquals((Object)this.ruleConfig.getPollInterval(), (Object)ruleConfig.getPollInterval());
        Assert.assertEquals((Object)this.ruleConfig.getScannerStatus(), (Object)ruleConfig.getScannerStatus());
        ProcessConfig processConfig = (ProcessConfig)spec.getConfigs().get(Capability.PROCESS);
        Assert.assertNotNull((Object)processConfig);
        Assert.assertEquals((Object)this.processConfig.getKBase(), (Object)processConfig.getKBase());
        Assert.assertEquals((Object)this.processConfig.getKSession(), (Object)processConfig.getKSession());
        Assert.assertEquals((Object)this.processConfig.getMergeMode(), (Object)processConfig.getMergeMode());
        Assert.assertEquals((Object)this.processConfig.getRuntimeStrategy(), (Object)processConfig.getRuntimeStrategy());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreServerTemplateDuplicate() {
        this.templateStorage.store(this.serverTemplate);
        boolean exists = this.templateStorage.exists(this.serverTemplate.getId());
        Assert.assertTrue((boolean)exists);
        this.templateStorage.store(this.serverTemplate);
        Assert.fail((String)"Duplicated server templates are not allowed, something is wrong...");
    }

    @Test
    public void testStoreAndLoadServerTemplates() {
        this.templateStorage.store(this.serverTemplate);
        List templateKeys = this.templateStorage.loadKeys();
        Assert.assertNotNull((Object)templateKeys);
        Assert.assertEquals((long)1L, (long)templateKeys.size());
        ServerTemplateKey templateKey = (ServerTemplateKey)templateKeys.iterator().next();
        Assert.assertNotNull((Object)templateKey);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)templateKey.getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.serverTemplate.getName(), (Object)templateKey.getName());
        }
        List templates = this.templateStorage.load();
        Assert.assertNotNull((Object)templates);
        Assert.assertEquals((long)1L, (long)templates.size());
        ServerTemplate template = (ServerTemplate)templates.iterator().next();
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)template.getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.serverTemplate.getName(), (Object)template.getName());
        }
        this.checkTemplateInstances(template);
        Collection containerSpecs = template.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec spec = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)spec);
        Assert.assertEquals((Object)this.containerSpec.getId(), (Object)spec.getId());
        Assert.assertEquals((Object)this.containerSpec.getReleasedId(), (Object)spec.getReleasedId());
        Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getId(), (Object)spec.getServerTemplateKey().getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getName(), (Object)spec.getServerTemplateKey().getName());
        }
        Assert.assertEquals((long)this.containerSpec.getConfigs().size(), (long)spec.getConfigs().size());
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.RULE));
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.PROCESS));
        RuleConfig ruleConfig = (RuleConfig)spec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfig);
        Assert.assertEquals((Object)this.ruleConfig.getPollInterval(), (Object)ruleConfig.getPollInterval());
        Assert.assertEquals((Object)this.ruleConfig.getScannerStatus(), (Object)ruleConfig.getScannerStatus());
        ProcessConfig processConfig = (ProcessConfig)spec.getConfigs().get(Capability.PROCESS);
        Assert.assertNotNull((Object)processConfig);
        Assert.assertEquals((Object)this.processConfig.getKBase(), (Object)processConfig.getKBase());
        Assert.assertEquals((Object)this.processConfig.getKSession(), (Object)processConfig.getKSession());
        Assert.assertEquals((Object)this.processConfig.getMergeMode(), (Object)processConfig.getMergeMode());
        Assert.assertEquals((Object)this.processConfig.getRuntimeStrategy(), (Object)processConfig.getRuntimeStrategy());
    }

    @Test
    public void testEmptyLoadServerTemplates() {
        List templateKeys = this.templateStorage.loadKeys();
        Assert.assertNotNull((Object)templateKeys);
        Assert.assertEquals((long)0L, (long)templateKeys.size());
        List templates = this.templateStorage.load();
        Assert.assertNotNull((Object)templates);
        Assert.assertEquals((long)0L, (long)templates.size());
    }

    @Test
    public void testEmptyLoadServerTemplate() {
        ServerTemplate template = this.templateStorage.load("not existing");
        Assert.assertNull((Object)template);
    }

    @Test
    public void testStoreLoadAndDeleteServerTemplate() {
        this.templateStorage.store(this.serverTemplate);
        List templateKeys = this.templateStorage.loadKeys();
        Assert.assertNotNull((Object)templateKeys);
        Assert.assertEquals((long)1L, (long)templateKeys.size());
        this.templateStorage.delete(this.serverTemplate.getId());
        boolean exists = this.templateStorage.exists(this.serverTemplate.getId());
        Assert.assertFalse((boolean)exists);
        ServerTemplate template = this.templateStorage.load("not existing");
        Assert.assertNull((Object)template);
        templateKeys = this.templateStorage.loadKeys();
        Assert.assertNotNull((Object)templateKeys);
        Assert.assertEquals((long)0L, (long)templateKeys.size());
    }

    @Test
    public void testStoreLoadAndUpdateServerTemplate() {
        this.templateStorage.store(this.serverTemplate);
        ServerTemplate fromStorage = this.templateStorage.load(this.serverTemplate.getId());
        Assert.assertNotNull((Object)fromStorage);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)fromStorage.getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.serverTemplate.getName(), (Object)fromStorage.getName());
        }
        ContainerSpec newContainerSpec = new ContainerSpec();
        newContainerSpec.setId("test container 2");
        newContainerSpec.setServerTemplateKey(new ServerTemplateKey(this.serverTemplate.getId(), this.serverTemplate.getName()));
        newContainerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "3.0"));
        newContainerSpec.setStatus(KieContainerStatus.STARTED);
        fromStorage.addContainerSpec(newContainerSpec);
        fromStorage.addServerInstance(ModelFactory.newServerInstanceKey((String)this.serverTemplate.getId(), (String)"http://localhost:8080/server"));
        this.templateStorage.update(fromStorage);
        ServerTemplate template = this.templateStorage.load(this.serverTemplate.getId());
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)template.getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.serverTemplate.getName(), (Object)template.getName());
        }
        Collection instances = template.getServerInstanceKeys();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)instances.iterator().next();
        Assert.assertNotNull((Object)serverInstanceKey);
        Assert.assertEquals((Object)this.serverTemplate.getId(), (Object)serverInstanceKey.getServerTemplateId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)(this.serverTemplate.getId() + "@localhost:8080"), (Object)serverInstanceKey.getServerName());
            Assert.assertEquals((Object)(this.serverTemplate.getId() + "@localhost:8080"), (Object)serverInstanceKey.getServerInstanceId());
            Assert.assertEquals((Object)"http://localhost:8080/server", (Object)serverInstanceKey.getUrl());
        }
        Collection containerSpecs = template.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)2L, (long)containerSpecs.size());
        Iterator iterator = containerSpecs.iterator();
        ContainerSpec spec = (ContainerSpec)iterator.next();
        Assert.assertNotNull((Object)spec);
        Assert.assertEquals((Object)this.containerSpec.getId(), (Object)spec.getId());
        Assert.assertEquals((Object)this.containerSpec.getReleasedId(), (Object)spec.getReleasedId());
        Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getId(), (Object)spec.getServerTemplateKey().getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)this.containerSpec.getServerTemplateKey().getName(), (Object)spec.getServerTemplateKey().getName());
        }
        Assert.assertEquals((long)this.containerSpec.getConfigs().size(), (long)spec.getConfigs().size());
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.RULE));
        Assert.assertTrue((boolean)spec.getConfigs().containsKey(Capability.PROCESS));
        RuleConfig ruleConfig = (RuleConfig)spec.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfig);
        Assert.assertEquals((Object)this.ruleConfig.getPollInterval(), (Object)ruleConfig.getPollInterval());
        Assert.assertEquals((Object)this.ruleConfig.getScannerStatus(), (Object)ruleConfig.getScannerStatus());
        ProcessConfig processConfig = (ProcessConfig)spec.getConfigs().get(Capability.PROCESS);
        Assert.assertNotNull((Object)processConfig);
        Assert.assertEquals((Object)this.processConfig.getKBase(), (Object)processConfig.getKBase());
        Assert.assertEquals((Object)this.processConfig.getKSession(), (Object)processConfig.getKSession());
        Assert.assertEquals((Object)this.processConfig.getMergeMode(), (Object)processConfig.getMergeMode());
        Assert.assertEquals((Object)this.processConfig.getRuntimeStrategy(), (Object)processConfig.getRuntimeStrategy());
        spec = (ContainerSpec)iterator.next();
        Assert.assertNotNull((Object)spec);
        Assert.assertEquals((Object)newContainerSpec.getId(), (Object)spec.getId());
        Assert.assertEquals((Object)newContainerSpec.getReleasedId(), (Object)spec.getReleasedId());
        Assert.assertEquals((Object)newContainerSpec.getServerTemplateKey().getId(), (Object)spec.getServerTemplateKey().getId());
        if (this.isEnclosedTestAssertionRequired()) {
            Assert.assertEquals((Object)newContainerSpec.getServerTemplateKey().getName(), (Object)spec.getServerTemplateKey().getName());
        }
        Assert.assertEquals((long)newContainerSpec.getConfigs().size(), (long)spec.getConfigs().size());
    }

    protected void createServerTemplateWithContainer() {
        this.serverTemplate = new ServerTemplate();
        this.serverTemplate.setName("test server");
        this.setServerTemplateId();
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        this.ruleConfig = new RuleConfig();
        this.ruleConfig.setPollInterval(Long.valueOf(1000L));
        this.ruleConfig.setScannerStatus(KieScannerStatus.STARTED);
        configs.put(Capability.RULE, this.ruleConfig);
        this.processConfig = new ProcessConfig();
        this.processConfig.setKBase("defaultKieBase");
        this.processConfig.setKSession("defaultKieSession");
        this.processConfig.setMergeMode("MERGE_COLLECTION");
        this.processConfig.setRuntimeStrategy("PER_PROCESS_INSTANCE");
        configs.put(Capability.PROCESS, this.processConfig);
        this.containerSpec = new ContainerSpec();
        this.containerSpec.setId("test container");
        this.containerSpec.setServerTemplateKey(new ServerTemplateKey(this.serverTemplate.getId(), this.serverTemplate.getName()));
        this.containerSpec.setReleasedId(new ReleaseId("org.kie", "kie-server-kjar", "1.0"));
        this.containerSpec.setStatus(KieContainerStatus.STOPPED);
        this.containerSpec.setConfigs(configs);
        this.serverTemplate.addContainerSpec(this.containerSpec);
        this.container = new Container();
        this.container.setServerInstanceId(this.serverTemplate.getId());
        this.container.setServerTemplateId(this.serverTemplate.getId());
        this.container.setResolvedReleasedId(this.containerSpec.getReleasedId());
        this.container.setContainerName(this.containerSpec.getContainerName());
        this.container.setContainerSpecId(this.containerSpec.getId());
        this.container.setUrl("http://fake.server.net/kie-server");
    }

    protected void setServerTemplateId() {
        this.serverTemplate.setId(UUID.randomUUID().toString());
    }

    protected void checkTemplateInstances(ServerTemplate fromStorage) {
        Collection instances = fromStorage.getServerInstanceKeys();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)0L, (long)instances.size());
    }

    protected boolean isEnclosedTestAssertionRequired() {
        return true;
    }
}

