/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerInstanceManagerTest {
    @Mock
    private ServerTemplate serverTemplate;
    @Mock
    private ContainerSpec containerSpec;
    @Mock
    private KieServicesClient client;
    @Mock
    private Container container;
    @Mock
    private ServiceResponse<?> response;
    @Mock
    private KieServerInstanceManager.RemoteKieServerOperation operation;
    @Mock
    private KieContainerResource containerResource;
    private KieServerInstanceManager instanceManager;

    @Before
    public void setUp() {
        this.instanceManager = (KieServerInstanceManager)Mockito.spy((Object)new KieServerInstanceManager());
    }

    @Test
    public void testGetContainers() {
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.operation).when((Object)this.instanceManager)).getContainersRemoteOperation(this.serverTemplate, this.containerSpec);
        this.instanceManager.getContainers(this.serverTemplate, this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
    }

    @Test
    public void testGetContainersRemoteOperationWhenResponseTypeIsSUCCESS() {
        ((ServiceResponse)Mockito.doReturn((Object)this.containerResource).when(this.response)).getResult();
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).getContainerInfo((String)Mockito.any());
        ((ServiceResponse)Mockito.doReturn((Object)KieServiceResponse.ResponseType.SUCCESS).when(this.response)).getType();
        KieServerInstanceManager.RemoteKieServerOperation operation = this.instanceManager.getContainersRemoteOperation(this.serverTemplate, this.containerSpec);
        operation.doOperation(this.client, this.container);
        ((Container)Mockito.verify((Object)this.container)).setContainerSpecId(this.containerResource.getContainerId());
        ((Container)Mockito.verify((Object)this.container)).setContainerName(this.containerResource.getContainerId());
        ((Container)Mockito.verify((Object)this.container)).setResolvedReleasedId(this.containerResource.getReleaseId());
        ((Container)Mockito.verify((Object)this.container)).setServerTemplateId(this.serverTemplate.getId());
        ((Container)Mockito.verify((Object)this.container)).setStatus(this.containerResource.getStatus());
        ((Container)Mockito.verify((Object)this.container)).setMessages((Collection)this.containerResource.getMessages());
    }

    @Test
    public void testGetContainersRemoteOperationWhenResponseTypeIsNotSUCCESS() {
        ((ServiceResponse)Mockito.doReturn((Object)this.containerResource).when(this.response)).getResult();
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).getContainerInfo((String)Mockito.any());
        ((ServiceResponse)Mockito.doReturn((Object)KieServiceResponse.ResponseType.FAILURE).when(this.response)).getType();
        KieServerInstanceManager.RemoteKieServerOperation operation = this.instanceManager.getContainersRemoteOperation(this.serverTemplate, this.containerSpec);
        operation.doOperation(this.client, this.container);
        ((Container)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setContainerSpecId((String)Mockito.any());
        ((Container)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setContainerName((String)Mockito.any());
        ((Container)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setResolvedReleasedId((ReleaseId)Mockito.any());
        ((Container)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setServerTemplateId((String)Mockito.any());
        ((Container)Mockito.verify((Object)this.container)).setStatus((KieContainerStatus)Mockito.any());
        ((Container)Mockito.verify((Object)this.container, (VerificationMode)Mockito.never())).setMessages((Collection)Mockito.any());
    }

    @Test
    public void testMakeContainerResourceWhenConfigsIsNull() {
        String id = "id";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ReleaseId resolvedReleasedId = (ReleaseId)Mockito.mock(ReleaseId.class);
        KieContainerStatus status = KieContainerStatus.CREATING;
        String containerName = "containerName";
        ArrayList messages = new ArrayList();
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((Container)Mockito.doReturn((Object)resolvedReleasedId).when((Object)this.container)).getResolvedReleasedId();
        ((Container)Mockito.doReturn((Object)status).when((Object)this.container)).getStatus();
        ((ContainerSpec)Mockito.doReturn((Object)"containerName").when((Object)this.containerSpec)).getContainerName();
        ((Container)Mockito.doReturn(messages).when((Object)this.container)).getMessages();
        ((ContainerSpec)Mockito.doReturn(null).when((Object)this.containerSpec)).getConfigs();
        KieContainerResource resource = this.instanceManager.makeContainerResource(this.container, this.containerSpec);
        Assert.assertEquals((Object)"id", (Object)resource.getContainerId());
        Assert.assertEquals((Object)releaseId, (Object)resource.getReleaseId());
        Assert.assertEquals((Object)resolvedReleasedId, (Object)resource.getResolvedReleaseId());
        Assert.assertEquals((Object)status, (Object)resource.getStatus());
        Assert.assertEquals((Object)"containerName", (Object)resource.getContainerAlias());
        Assert.assertEquals(messages, (Object)resource.getMessages());
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager, (VerificationMode)Mockito.never())).setRuleConfigAttributes((ContainerSpec)Mockito.any(), (KieContainerResource)Mockito.any());
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager, (VerificationMode)Mockito.never())).setProcessConfigAttributes((ContainerSpec)Mockito.any(), (KieContainerResource)Mockito.any());
    }

    @Test
    public void testStartContainer() {
        List expectedContainers = (List)Mockito.mock(List.class);
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.operation).when((Object)this.instanceManager)).makeStartContainerOperation(this.containerSpec);
        ((KieServerInstanceManager)Mockito.doReturn((Object)expectedContainers).when((Object)this.instanceManager)).callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
        List actualContainers = this.instanceManager.startContainer(this.serverTemplate, this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
        Assert.assertEquals((Object)expectedContainers, (Object)actualContainers);
    }

    @Test
    public void testMakeStartContainerOperationWhenResponseTypeIsSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.SUCCESS;
        String containerId = "id";
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.containerResource).when((Object)this.instanceManager)).makeContainerResource(this.container, this.containerSpec);
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).createContainer("id", this.containerResource);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeStartContainerOperation(this.containerSpec).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client)).createContainer("id", this.containerResource);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager, (VerificationMode)Mockito.never())).log((String)Mockito.any(), new Object[]{Mockito.any(), Mockito.any(), Mockito.any()});
    }

    @Test
    public void testMakeStartContainerOperationWhenResponseTypeIsNotSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.FAILURE;
        String containerId = "id";
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.containerResource).when((Object)this.instanceManager)).makeContainerResource(this.container, this.containerSpec);
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).createContainer("id", this.containerResource);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeStartContainerOperation(this.containerSpec).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client)).createContainer("id", this.containerResource);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).log("Container {} failed to start on server instance {} due to {}", new Object[]{this.container, this.response, this.containerSpec});
    }

    @Test
    public void testMakeUpgradeContainerOperationWhenResponseTypeIsSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.SUCCESS;
        String containerId = "id";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeUpgradeContainerOperation(this.containerSpec, false).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).createContainer(Mockito.anyString(), (KieContainerResource)Mockito.any(KieContainerResource.class));
        ((KieServicesClient)Mockito.verify((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager, (VerificationMode)Mockito.never())).log((String)Mockito.any(), new Object[]{Mockito.any(), Mockito.any(), Mockito.any()});
    }

    @Test
    public void testMakeUpgradeContainerOperationWhenResponseTypeIsNotSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.FAILURE;
        String containerId = "id";
        String url = "url";
        String msg = "msg";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((ServiceResponse)Mockito.doReturn((Object)"msg").when(this.response)).getMsg();
        ((Container)Mockito.doReturn((Object)"url").when((Object)this.container)).getUrl();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeUpgradeContainerOperation(this.containerSpec, false).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).createContainer(Mockito.anyString(), (KieContainerResource)Mockito.any(KieContainerResource.class));
        ((KieServicesClient)Mockito.verify((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).log("Container {} failed to upgrade on server instance {} due to {}", new Object[]{"id", "url", "msg"});
    }

    @Test
    public void testMakeUpgradeAndStartContainerOperationWhenResponseTypeIsSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.SUCCESS;
        String containerId = "id";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.containerResource).when((Object)this.instanceManager)).makeContainerResource(this.container, this.containerSpec);
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeUpgradeAndStartContainerOperation(this.containerSpec, false).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client)).createContainer("id", this.containerResource);
        ((KieServicesClient)Mockito.verify((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager, (VerificationMode)Mockito.never())).log((String)Mockito.any(), new Object[]{Mockito.any(), Mockito.any(), Mockito.any()});
    }

    @Test
    public void testMakeUpgradeAndStartContainerOperationWhenResponseTypeIsNotSuccess() {
        KieServiceResponse.ResponseType responseType = KieServiceResponse.ResponseType.FAILURE;
        String containerId = "id";
        String url = "url";
        String msg = "msg";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.containerResource).when((Object)this.instanceManager)).makeContainerResource(this.container, this.containerSpec);
        ((KieServicesClient)Mockito.doReturn(this.response).when((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((ServiceResponse)Mockito.doReturn((Object)responseType).when(this.response)).getType();
        ((ServiceResponse)Mockito.doReturn((Object)"msg").when(this.response)).getMsg();
        ((Container)Mockito.doReturn((Object)"url").when((Object)this.container)).getUrl();
        ((KieServerInstanceManager)Mockito.doNothing().when((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        this.instanceManager.makeUpgradeAndStartContainerOperation(this.containerSpec, false).doOperation(this.client, this.container);
        ((KieServicesClient)Mockito.verify((Object)this.client)).createContainer("id", this.containerResource);
        ((KieServicesClient)Mockito.verify((Object)this.client)).updateReleaseId("id", releaseId, false);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).collectContainerInfo(this.containerSpec, this.client, this.container);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).log("Container {} failed to upgrade on server instance {} due to {}", new Object[]{"id", "url", "msg"});
    }

    @Test
    public void testMakeContainerResourceWhenConfigsIsNotNull() {
        String id = "id";
        ReleaseId releaseId = (ReleaseId)Mockito.mock(ReleaseId.class);
        ReleaseId resolvedReleasedId = (ReleaseId)Mockito.mock(ReleaseId.class);
        KieContainerStatus status = KieContainerStatus.CREATING;
        String containerName = "containerName";
        ArrayList messages = new ArrayList();
        Map configs = (Map)Mockito.mock(Map.class);
        ((ContainerSpec)Mockito.doReturn((Object)"id").when((Object)this.containerSpec)).getId();
        ((ContainerSpec)Mockito.doReturn((Object)releaseId).when((Object)this.containerSpec)).getReleasedId();
        ((Container)Mockito.doReturn((Object)resolvedReleasedId).when((Object)this.container)).getResolvedReleasedId();
        ((Container)Mockito.doReturn((Object)status).when((Object)this.container)).getStatus();
        ((ContainerSpec)Mockito.doReturn((Object)"containerName").when((Object)this.containerSpec)).getContainerName();
        ((Container)Mockito.doReturn(messages).when((Object)this.container)).getMessages();
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)this.containerSpec)).getConfigs();
        KieContainerResource resource = this.instanceManager.makeContainerResource(this.container, this.containerSpec);
        Assert.assertEquals((Object)"id", (Object)resource.getContainerId());
        Assert.assertEquals((Object)releaseId, (Object)resource.getReleaseId());
        Assert.assertEquals((Object)resolvedReleasedId, (Object)resource.getResolvedReleaseId());
        Assert.assertEquals((Object)status, (Object)resource.getStatus());
        Assert.assertEquals((Object)"containerName", (Object)resource.getContainerAlias());
        Assert.assertEquals(messages, (Object)resource.getMessages());
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).setRuleConfigAttributes(this.containerSpec, resource);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).setProcessConfigAttributes(this.containerSpec, resource);
    }

    @Test
    public void testMakeKieServerConfigItem() {
        String type = "type";
        String name = "name";
        String value = "value";
        KieServerConfigItem configItem = this.instanceManager.makeKieServerConfigItem("type", "name", "value");
        Assert.assertEquals((Object)"type", (Object)configItem.getType());
        Assert.assertEquals((Object)"name", (Object)configItem.getName());
        Assert.assertEquals((Object)"value", (Object)configItem.getValue());
    }

    @Test
    public void testSetRuleConfigAttributesWhenRuleConfigIsNotNull() {
        Map configs = (Map)Mockito.mock(Map.class);
        RuleConfig containerConfig = (RuleConfig)Mockito.mock(RuleConfig.class);
        ArgumentCaptor scannerResourceCaptor = ArgumentCaptor.forClass(KieScannerResource.class);
        Long pollInterval = 1L;
        KieScannerStatus scannerStatus = KieScannerStatus.CREATED;
        ((RuleConfig)Mockito.doReturn((Object)pollInterval).when((Object)containerConfig)).getPollInterval();
        ((RuleConfig)Mockito.doReturn((Object)scannerStatus).when((Object)containerConfig)).getScannerStatus();
        ((Map)Mockito.doReturn((Object)containerConfig).when((Object)configs)).get(Capability.RULE);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)this.containerSpec)).getConfigs();
        this.instanceManager.setRuleConfigAttributes(this.containerSpec, this.containerResource);
        ((KieContainerResource)Mockito.verify((Object)this.containerResource)).setScanner((KieScannerResource)scannerResourceCaptor.capture());
        KieScannerResource scannerResource = (KieScannerResource)scannerResourceCaptor.getValue();
        Assert.assertEquals((Object)pollInterval, (Object)scannerResource.getPollInterval());
        Assert.assertEquals((Object)scannerStatus, (Object)scannerResource.getStatus());
    }

    @Test
    public void testSetRuleConfigAttributesWhenRuleConfigIsNull() {
        Map configs = (Map)Mockito.mock(Map.class);
        ((Map)Mockito.doReturn(null).when((Object)configs)).get(Capability.RULE);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)this.containerSpec)).getConfigs();
        this.instanceManager.setRuleConfigAttributes(this.containerSpec, this.containerResource);
        ((KieContainerResource)Mockito.verify((Object)this.containerResource, (VerificationMode)Mockito.never())).setScanner((KieScannerResource)Mockito.any());
    }

    @Test
    public void testSetProcessConfigAttributesWhenProcessConfigIsNotNull() {
        Map configs = (Map)Mockito.mock(Map.class);
        ProcessConfig processConfig = new ProcessConfig("runtimeStrategy", "kBase", "kSession", "mergeMode");
        KieContainerResource containerResource = (KieContainerResource)Mockito.spy((Object)new KieContainerResource());
        List actualConfigItems = containerResource.getConfigItems();
        KieServerConfigItem expectedConfigItem0 = this.configItem("BPM", "KBase", processConfig.getKBase());
        KieServerConfigItem expectedConfigItem1 = this.configItem("BPM", "KSession", processConfig.getKSession());
        KieServerConfigItem expectedConfigItem2 = this.configItem("BPM", "MergeMode", processConfig.getMergeMode());
        KieServerConfigItem expectedConfigItem3 = this.configItem("BPM", "RuntimeStrategy", processConfig.getRuntimeStrategy());
        ((Map)Mockito.doReturn((Object)processConfig).when((Object)configs)).get(Capability.PROCESS);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)this.containerSpec)).getConfigs();
        this.instanceManager.setProcessConfigAttributes(this.containerSpec, containerResource);
        Assert.assertEquals((Object)expectedConfigItem0, actualConfigItems.get(0));
        Assert.assertEquals((Object)expectedConfigItem1, actualConfigItems.get(1));
        Assert.assertEquals((Object)expectedConfigItem2, actualConfigItems.get(2));
        Assert.assertEquals((Object)expectedConfigItem3, actualConfigItems.get(3));
        Assert.assertEquals((long)4L, (long)actualConfigItems.size());
    }

    @Test
    public void testSetProcessConfigAttributesWhenProcessConfigIsNull() {
        Map configs = (Map)Mockito.mock(Map.class);
        KieContainerResource containerResource = (KieContainerResource)Mockito.spy((Object)new KieContainerResource());
        List actualConfigItems = containerResource.getConfigItems();
        ((Map)Mockito.doReturn(null).when((Object)configs)).get(Capability.PROCESS);
        ((ContainerSpec)Mockito.doReturn((Object)configs).when((Object)this.containerSpec)).getConfigs();
        this.instanceManager.setProcessConfigAttributes(this.containerSpec, containerResource);
        Assert.assertEquals((long)0L, (long)actualConfigItems.size());
    }

    @Test
    public void testUpgradeContainer() {
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.operation).when((Object)this.instanceManager)).makeUpgradeContainerOperation(this.containerSpec, false);
        this.instanceManager.upgradeContainer(this.serverTemplate, this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
    }

    @Test
    public void testUpgradeAndStartContainer() {
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.operation).when((Object)this.instanceManager)).makeUpgradeAndStartContainerOperation(this.containerSpec, false);
        this.instanceManager.upgradeAndStartContainer(this.serverTemplate, this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.instanceManager)).callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
    }

    @Test
    public void testCallRemoteKieServerOperationWhenContainerSpecIsNull() {
        List containers = this.instanceManager.callRemoteKieServerOperation(this.serverTemplate, null, this.operation);
        Assert.assertTrue((boolean)containers.isEmpty());
    }

    @Test
    public void testCallRemoteKieServerOperationWhenServerTemplateHasZeroServerInstanceKeys() {
        List serverInstanceKeys = Collections.emptyList();
        Mockito.when((Object)this.serverTemplate.getServerInstanceKeys()).thenReturn(serverInstanceKeys);
        List containers = this.instanceManager.callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
        Assert.assertTrue((boolean)containers.isEmpty());
    }

    @Test
    public void testCallRemoteKieServerOperationWhenGetClientThrowsAnException() {
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)Mockito.mock(ServerInstanceKey.class);
        List<ServerInstanceKey> serverInstanceKeys = Collections.singletonList(serverInstanceKey);
        Mockito.when((Object)this.serverTemplate.getServerInstanceKeys()).thenReturn(serverInstanceKeys);
        ((KieServerInstanceManager)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException()}).when((Object)this.instanceManager)).getClient((String)Mockito.any());
        List containers = this.instanceManager.callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
        Assert.assertTrue((boolean)containers.isEmpty());
    }

    @Test
    public void testCallRemoteKieServerOperationWhenServerTemplateHasMoreThanZeroServerInstanceKeys() {
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)Mockito.mock(ServerInstanceKey.class);
        List<ServerInstanceKey> serverInstanceKeys = Collections.singletonList(serverInstanceKey);
        Mockito.when((Object)this.serverTemplate.getServerInstanceKeys()).thenReturn(serverInstanceKeys);
        ((KieServerInstanceManager)Mockito.doReturn((Object)this.client).when((Object)this.instanceManager)).getClient((String)Mockito.any());
        List containers = this.instanceManager.callRemoteKieServerOperation(this.serverTemplate, this.containerSpec, this.operation);
        Assert.assertEquals((long)1L, (long)containers.size());
    }

    private KieServerConfigItem configItem(String capabilityBpm, String pcfgKieBase, String kBase) {
        return this.instanceManager.makeKieServerConfigItem(capabilityBpm, pcfgKieBase, kBase);
    }
}

