/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.service.AbstractServiceImplTest;
import org.kie.server.controller.impl.service.RuleCapabilitiesServiceImpl;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuleCapabilitiesServiceImplTest
extends AbstractServiceImplTest {
    @Before
    public void setup() {
        this.ruleCapabilitiesService = new RuleCapabilitiesServiceImpl();
        this.specManagementService = new SpecManagementServiceImpl();
        this.kieServerInstanceManager = (KieServerInstanceManager)Mockito.mock(KieServerInstanceManager.class);
        ((RuleCapabilitiesServiceImpl)this.ruleCapabilitiesService).setKieServerInstanceManager(this.kieServerInstanceManager);
        this.createServerTemplateWithContainer();
    }

    @After
    public void cleanup() {
        InMemoryKieServerTemplateStorage.getInstance().clear();
    }

    @Test
    public void testScanNow() {
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.scanNow((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.ruleCapabilitiesService.scanNow((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).scanNow((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
    }

    @Test
    public void testStartScanner() {
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.startScanner((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class), Mockito.anyLong())).thenReturn(fakeResult);
        this.ruleCapabilitiesService.startScanner((ContainerSpecKey)this.containerSpec, Long.valueOf(100L));
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).startScanner((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class), Mockito.anyLong());
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Collection containerSpecs = updated.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec updatedContainer = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)updatedContainer);
        ContainerConfig ruleConfig = (ContainerConfig)updatedContainer.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfig);
        Assert.assertTrue((boolean)(ruleConfig instanceof RuleConfig));
        RuleConfig ruleCg = (RuleConfig)ruleConfig;
        Assert.assertEquals((Object)KieScannerStatus.STARTED, (Object)ruleCg.getScannerStatus());
        Assert.assertEquals((long)100L, (long)ruleCg.getPollInterval());
    }

    @Test
    public void testStopScanner() {
        ArrayList<Container> fakeResult = new ArrayList<Container>();
        fakeResult.add(this.container);
        Mockito.when((Object)this.kieServerInstanceManager.stopScanner((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class))).thenReturn(fakeResult);
        this.ruleCapabilitiesService.stopScanner((ContainerSpecKey)this.containerSpec);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager, (VerificationMode)Mockito.times((int)1))).stopScanner((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Collection containerSpecs = updated.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec updatedContainer = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)updatedContainer);
        ContainerConfig ruleConfig = (ContainerConfig)updatedContainer.getConfigs().get(Capability.RULE);
        Assert.assertNotNull((Object)ruleConfig);
        Assert.assertTrue((boolean)(ruleConfig instanceof RuleConfig));
        RuleConfig ruleCg = (RuleConfig)ruleConfig;
        Assert.assertEquals((Object)KieScannerStatus.STOPPED, (Object)ruleCg.getScannerStatus());
        Assert.assertNull((Object)ruleCg.getPollInterval());
    }

    @Test
    public void testUpgradeContainerWhenContainerSpecStatusIsStarted() {
        ArrayList<Container> fakeResult = new ArrayList<Container>(){
            {
                this.add(RuleCapabilitiesServiceImplTest.this.container);
            }
        };
        ((KieServerInstanceManager)Mockito.doReturn((Object)fakeResult).when((Object)this.kieServerInstanceManager)).upgradeContainer((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
        this.containerSpec.setStatus(KieContainerStatus.STARTED);
        ReleaseId initial = this.containerSpec.getReleasedId();
        ReleaseId upgradeTo = new ReleaseId("org.kie", "kie-server-kjar", "2.0");
        this.ruleCapabilitiesService.upgradeContainer((ContainerSpecKey)this.containerSpec, upgradeTo);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager)).upgradeContainer((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Collection containerSpecs = updated.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec updatedContainer = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertNotNull((Object)updatedContainer.getReleasedId());
        Assert.assertNotEquals((Object)initial, (Object)updatedContainer.getReleasedId());
        Assert.assertEquals((Object)upgradeTo, (Object)updatedContainer.getReleasedId());
        Assert.assertEquals((Object)updatedContainer.getStatus(), (Object)KieContainerStatus.STARTED);
    }

    @Test
    public void testUpgradeContainerWhenContainerSpecStatusIsStopped() {
        ArrayList<Container> fakeResult = new ArrayList<Container>(){
            {
                this.add(RuleCapabilitiesServiceImplTest.this.container);
            }
        };
        ((KieServerInstanceManager)Mockito.doReturn((Object)fakeResult).when((Object)this.kieServerInstanceManager)).startContainer((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
        this.containerSpec.setStatus(KieContainerStatus.STOPPED);
        ReleaseId initial = this.containerSpec.getReleasedId();
        ReleaseId upgradeTo = new ReleaseId("org.kie", "kie-server-kjar", "2.0");
        this.ruleCapabilitiesService.upgradeContainer((ContainerSpecKey)this.containerSpec, upgradeTo);
        ((KieServerInstanceManager)Mockito.verify((Object)this.kieServerInstanceManager)).startContainer((ServerTemplate)Mockito.any(ServerTemplate.class), (ContainerSpec)Mockito.any(ContainerSpec.class));
        ServerTemplate updated = this.specManagementService.getServerTemplate(this.serverTemplate.getId());
        Collection containerSpecs = updated.getContainersSpec();
        Assert.assertNotNull((Object)containerSpecs);
        Assert.assertEquals((long)1L, (long)containerSpecs.size());
        ContainerSpec updatedContainer = (ContainerSpec)containerSpecs.iterator().next();
        Assert.assertNotNull((Object)updatedContainer);
        Assert.assertNotNull((Object)updatedContainer.getReleasedId());
        Assert.assertNotEquals((Object)initial, (Object)updatedContainer.getReleasedId());
        Assert.assertEquals((Object)upgradeTo, (Object)updatedContainer.getReleasedId());
        Assert.assertEquals((Object)updatedContainer.getStatus(), (Object)KieContainerStatus.STARTED);
    }
}

