/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.openshift.storage;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftServer;
import java.util.List;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.openshift.storage.ServerTemplateConverter;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;

public class ServerTemplateConverterTest {
    public static final String TEST_KIE_SERVER_ID = "myapp2-kieserver";
    private String testNamespace = "myproject";
    private OpenShiftClient client;
    private KieServerStateOpenShiftRepository repo;
    @Rule
    public OpenShiftServer server = new OpenShiftServer(false, true);

    @Before
    public void setup() {
        this.client = this.server.getOpenshiftClient();
        this.testNamespace = "test";
        ConfigMap cfm = (ConfigMap)((Resource)this.client.configMaps().load(ServerTemplateConverterTest.class.getResourceAsStream("/test-kieserver-state-config-map.yml"))).get();
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cfm});
        this.repo = new KieServerStateOpenShiftRepository(){

            public OpenShiftClient createOpenShiftClient() {
                return ServerTemplateConverterTest.this.client;
            }

            public KubernetesClient createKubernetesClient() {
                return ServerTemplateConverterTest.this.client;
            }

            public boolean isKieServerReady() {
                return true;
            }
        };
        this.repo.load(TEST_KIE_SERVER_ID);
    }

    @Test
    public void testFromState() {
        KieServerState state = this.repo.load(TEST_KIE_SERVER_ID);
        ServerTemplate template = ServerTemplateConverter.fromState((KieServerState)state);
        Assert.assertTrue((boolean)ServerTemplateConverterTest.isMatching(template, state));
    }

    @Test
    public void testFromStateWithoutServerLocation() {
        KieServerState state = this.repo.load(TEST_KIE_SERVER_ID);
        KieServerConfigItem cfgItem = state.getConfiguration().getConfigItem("org.kie.server.location");
        state.getConfiguration().removeConfigItem(cfgItem);
        ServerTemplate template = ServerTemplateConverter.fromState((KieServerState)state);
        Assert.assertTrue((boolean)ServerTemplateConverterTest.isMatching(template, state));
    }

    @Test
    public void testToState() {
        String tmpId = "myapp2-kieserver-from-template";
        KieServerState state = this.repo.load(TEST_KIE_SERVER_ID);
        ServerTemplate template = ServerTemplateConverter.fromState((KieServerState)state);
        template.setId(tmpId);
        template.setName(tmpId);
        template.getServerInstance(TEST_KIE_SERVER_ID).setServerInstanceId(tmpId);
        template.getServerInstance(tmpId).setServerName(tmpId);
        template.getServerInstance(tmpId).setServerTemplateId(tmpId);
        template.getContainersSpec().stream().forEach(conSpec -> {
            conSpec.setId(tmpId);
            conSpec.setContainerName(tmpId);
            conSpec.setServerTemplateKey(new ServerTemplateKey(tmpId, tmpId));
        });
        this.repo.create(ServerTemplateConverter.toState((ServerTemplate)template));
        state = this.repo.load(tmpId);
        Assert.assertTrue((boolean)ServerTemplateConverterTest.isMatching(template, state));
    }

    @Test
    public void testResolveServerUrl() {
        if (ServerTemplateConverter.PREFER_KIESERVER_SERVICE) {
            KieServerState state = this.repo.load(TEST_KIE_SERVER_ID);
            Assert.assertEquals((Object)"http://172.30.99.129:8080/services/rest/server", (Object)ServerTemplateConverter.fromState((KieServerState)state).getServerInstance(TEST_KIE_SERVER_ID).getUrl());
        }
    }

    @After
    public void tearDown() {
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete();
        this.client.close();
    }

    private static boolean isMatching(ServerTemplate template, KieServerState state) {
        boolean result = true;
        String id = null;
        String mode = null;
        Optional urlOpt = Optional.empty();
        try {
            id = state.getConfiguration().getConfigItemValue("org.kie.server.id");
            mode = state.getConfiguration().getConfigItemValue("org.kie.server.mode");
            urlOpt = ServerTemplateConverter.resolveServerUrl((KieServerState)state);
            if (!template.getId().equals(id)) {
                Assert.fail((String)"Id doesn't match!");
            }
            if (!template.getName().equals(id)) {
                Assert.fail((String)"Name doesn't match!");
            }
            if (urlOpt.isPresent()) {
                if (template.getServerInstanceKeys().size() != 1) {
                    Assert.fail((String)("ServerTemplate can have ONLY ONE server instance, but now contains: [" + template.getServerInstanceKeys().size() + "]."));
                }
                if (!template.hasServerInstanceId(id)) {
                    Assert.fail((String)"Server instance id missing.");
                }
                if (!template.hasServerInstance((String)urlOpt.get())) {
                    Assert.fail((String)"Server URL missing.");
                }
                if (!template.getServerInstance(id).getServerName().equals(id)) {
                    Assert.fail((String)"Server instance name doesn't match up with Id!");
                }
                if (!template.getServerInstance(id).getServerTemplateId().equals(id)) {
                    Assert.fail((String)"Server instance templateId doesn't match up with Id!");
                }
                if (!template.getServerInstance(id).getUrl().equals(urlOpt.get())) {
                    Assert.fail((String)"Server URL doesn't match!");
                }
            } else if (template.getServerInstanceKeys().size() != 0) {
                Assert.fail((String)"Should not have server instance.");
            }
            if (template.getMode() == null || !template.getMode().equals((Object)KieServerMode.valueOf((String)mode))) {
                Assert.fail((String)"Server MODE doesn't match!");
            }
            for (ContainerSpec conSpec : template.getContainersSpec()) {
                String conId = conSpec.getId();
                String conName = conSpec.getContainerName();
                ReleaseId relId = conSpec.getReleasedId();
                KieContainerStatus status = conSpec.getStatus();
                KieContainerResource conResFound = null;
                if (!conSpec.getServerTemplateKey().getId().equals(id)) {
                    Assert.fail((String)"Server template id within container spec doesn't match!");
                }
                if (!conSpec.getServerTemplateKey().getName().equals(id)) {
                    Assert.fail((String)"Server template name within container spec doesn't match!");
                }
                for (KieContainerResource conRes : state.getContainers()) {
                    if (!conRes.getReleaseId().equals((Object)relId)) continue;
                    conResFound = conRes;
                    break;
                }
                if (conResFound == null) {
                    Assert.fail((String)("Container Spec/Resource doesn't match! Container Id: [" + conId + "]"));
                }
                if (!conResFound.getContainerId().equals(conId)) {
                    Assert.fail((String)"Container Id doesn't match!");
                }
                if (!conResFound.getContainerAlias().equals(conName)) {
                    Assert.fail((String)"Container Name/Alias doesn't match!");
                }
                if (!conResFound.getReleaseId().equals((Object)relId)) {
                    Assert.fail((String)"Container releaseId doesn't match!");
                }
                if (!conResFound.getStatus().equals((Object)status)) {
                    Assert.fail((String)"Container status doesn't match!");
                }
                List cfgItems = conResFound.getConfigItems();
                for (ContainerConfig conCfg : conSpec.getConfigs().values()) {
                    if (conCfg instanceof ProcessConfig) {
                        ProcessConfig pconfig = (ProcessConfig)conCfg;
                        if (pconfig.getKBase() != null && !pconfig.getKBase().equals(ServerTemplateConverterTest.getConfigItemValue("KBase", cfgItems)) && !"BPM".equals(ServerTemplateConverterTest.getConfigItem("KBase", cfgItems).getType())) {
                            Assert.fail((String)"Container config: value of KBase doesn't match!");
                        }
                        if (pconfig.getKSession() != null && !pconfig.getKSession().equals(ServerTemplateConverterTest.getConfigItemValue("KSession", cfgItems)) && !"BPM".equals(ServerTemplateConverterTest.getConfigItem("KSession", cfgItems).getType())) {
                            Assert.fail((String)"Container config: value of KSession doesn't match!");
                        }
                        if (pconfig.getMergeMode() != null && !pconfig.getMergeMode().equals(ServerTemplateConverterTest.getConfigItemValue("MergeMode", cfgItems)) && !"BPM".equals(ServerTemplateConverterTest.getConfigItem("MergeMode", cfgItems).getType())) {
                            Assert.fail((String)"Container config: value of MergeMode doesn't match!");
                        }
                        if (pconfig.getRuntimeStrategy() == null || pconfig.getRuntimeStrategy().equals(ServerTemplateConverterTest.getConfigItemValue("RuntimeStrategy", cfgItems)) || "BPM".equals(ServerTemplateConverterTest.getConfigItem("RuntimeStrategy", cfgItems).getType())) continue;
                        Assert.fail((String)"Container config: value of RuntimeStrategy doesn't match!");
                        continue;
                    }
                    if (!(conCfg instanceof RuleConfig)) continue;
                    RuleConfig rconfig = (RuleConfig)conCfg;
                    KieScannerResource sRes = conResFound.getScanner();
                    if (sRes == null) {
                        Assert.fail((String)"Container config: Scanner can't be null!");
                    }
                    if (rconfig.getScannerStatus() != null && !rconfig.getScannerStatus().equals((Object)sRes.getStatus())) {
                        Assert.fail((String)"Container config: Scanner status doesn't match!");
                    }
                    if (rconfig.getPollInterval() == null || rconfig.getPollInterval().toString().equals(sRes.getPollInterval().toString())) continue;
                    Assert.fail((String)"Container config: Scanner PollInterval doesn't match!");
                }
            }
            KieServerConfig kcfg = state.getConfiguration();
            if (kcfg.getConfigItem("org.jbpm.server.ext.disabled") != null && template.getCapabilities().contains(Capability.PROCESS.name())) {
                Assert.fail((String)("Server Template can not specify disabled capability: [" + Capability.PROCESS + "]."));
            }
            if (kcfg.getConfigItem("org.drools.server.ext.disabled") != null && template.getCapabilities().contains(Capability.RULE.name())) {
                Assert.fail((String)("Server Template can not specify disabled capability: [" + Capability.RULE + "]."));
            }
            if (kcfg.getConfigItem("org.optaplanner.server.ext.disabled") != null && template.getCapabilities().contains(Capability.PLANNING.name())) {
                Assert.fail((String)("Server Template can not specify disabled capability: [" + Capability.PLANNING + "]."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return result;
    }

    private static KieServerConfigItem getConfigItem(String name, List<KieServerConfigItem> configItems) {
        KieServerConfigItem configItem = null;
        for (KieServerConfigItem item : configItems) {
            if (!name.equals(item.getName())) continue;
            configItem = item;
            break;
        }
        return configItem;
    }

    private static String getConfigItemValue(String name, List<KieServerConfigItem> configItems) {
        KieServerConfigItem item = ServerTemplateConverterTest.getConfigItem(name, configItems);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }
}

