/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.openshift.storage;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.server.mock.OpenShiftServer;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.impl.storage.ServerTemplateStorageTest;
import org.kie.server.controller.openshift.storage.OpenShiftServerTemplateStorage;
import org.kie.server.services.openshift.impl.storage.cloud.CloudClientFactory;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateOpenShiftRepository;

public class OpenShiftServerTemplateStorageTest
extends ServerTemplateStorageTest {
    private static Supplier<OpenShiftClient> clouldClientHelper = () -> new CloudClientFactory(){}.createOpenShiftClient();
    private String testNamespace = "test";
    private OpenShiftClient client;
    protected static final String TEST_APP_NAME = "myapp2";
    @Rule
    public OpenShiftServer server = new OpenShiftServer(false, true);

    @Before
    public void setup() throws IOException {
        if (System.getenv("KIE_SERVER_ID") != null) {
            System.setProperty("org.kie.server.startup.strategy", "OpenShiftStartupStrategy");
            this.client = clouldClientHelper.get();
        } else {
            this.client = this.server.getOpenshiftClient();
        }
        KieServerStateOpenShiftRepository repo = new KieServerStateOpenShiftRepository(){

            public OpenShiftClient createOpenShiftClient() {
                return OpenShiftServerTemplateStorageTest.this.client;
            }

            public KubernetesClient createKubernetesClient() {
                return OpenShiftServerTemplateStorageTest.this.client;
            }

            public boolean isKieServerReady() {
                return true;
            }

            public boolean isDCStable(DeploymentConfig dc) {
                return true;
            }

            public Optional<String> getAppNameFromPod(OpenShiftClient client) {
                return Optional.of(OpenShiftServerTemplateStorageTest.TEST_APP_NAME);
            }

            public ConfigMap createOrReplaceCM(OpenShiftClient client, ConfigMap cm) {
                ((NonNamespaceOperation)client.configMaps().inNamespace(OpenShiftServerTemplateStorageTest.this.testNamespace)).delete((Object[])new ConfigMap[]{cm});
                return (ConfigMap)((NonNamespaceOperation)client.configMaps().inNamespace(OpenShiftServerTemplateStorageTest.this.testNamespace)).createOrReplace((Object[])new ConfigMap[]{cm});
            }
        };
        this.templateStorage = new OpenShiftServerTemplateStorage(repo);
        this.createServerTemplateWithContainer();
    }

    protected void checkTemplateInstances(ServerTemplate fromStorage) {
        Collection instances = fromStorage.getServerInstanceKeys();
        Assert.assertNotNull((Object)instances);
        Assert.assertEquals((long)1L, (long)instances.size());
    }

    protected boolean isEnclosedTestAssertionRequired() {
        return false;
    }

    protected void setServerTemplateId() {
        this.serverTemplate.setId("myapp2-kieserver");
    }

    @Test
    public void testLoadKeysWithCache() {
        OpenShiftServerTemplateStorage ocpStorage = (OpenShiftServerTemplateStorage)this.templateStorage;
        ocpStorage.store(this.serverTemplate);
        Assert.assertEquals((long)1L, (long)ocpStorage.loadKeys().size());
        ocpStorage.repo.delete(this.serverTemplate.getId());
        Assert.assertEquals((long)1L, (long)ocpStorage.loadKeys().size());
    }

    @Test
    public void testLoadKeysWithCacheExpire() {
        OpenShiftServerTemplateStorage ocpStorage = (OpenShiftServerTemplateStorage)this.templateStorage;
        ocpStorage.cacheTTL = 10L;
        ocpStorage.store(this.serverTemplate);
        Assert.assertEquals((long)1L, (long)ocpStorage.loadKeys().size());
        ocpStorage.repo.delete(this.serverTemplate.getId());
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ocpStorage.loadKeys().size());
    }

    @Test
    public void testLoadWithCache() {
        OpenShiftServerTemplateStorage ocpStorage = (OpenShiftServerTemplateStorage)this.templateStorage;
        ocpStorage.store(this.serverTemplate);
        Assert.assertEquals((long)1L, (long)ocpStorage.load().size());
        ocpStorage.repo.delete(this.serverTemplate.getId());
        Assert.assertEquals((long)1L, (long)ocpStorage.load().size());
    }

    @After
    public void cleanup() {
        ((NonNamespaceOperation)this.client.configMaps().inNamespace(this.testNamespace)).delete();
        this.client.close();
    }
}

