/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.builder.ContainerBuilder;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;

@Mojo(name="create-container", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=true)
public class CreateContainerMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=true)
    protected String templateId;
    @Parameter(property="kie-ctrl.template-name")
    private String templateName;
    @Parameter(property="kie-ctrl.container")
    protected String container;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="kie-ctrl.runtime-strategy")
    private String runtimeStrategy;
    @Parameter(property="kie-ctrl.kbase")
    private String kbase;
    @Parameter(property="kie-ctrl.ksession")
    private String ksession;
    @Parameter(property="kie-ctrl.mergeMode")
    private String mergeMode;
    @Parameter(property="kie-ctrl.pollInterval")
    private Long pollInterval;
    @Parameter(property="kie-ctrl.scannerStatus")
    private String scannerStatus;

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        if (this.templateName == null || this.templateName.isEmpty()) {
            this.templateName = this.templateId;
        }
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        this.getLog().info((CharSequence)("Server Template Name: " + this.templateName));
        ContainerBuilder containerBuilder = ContainerBuilder.create(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()).id(this.container).runtimeStrategy(this.runtimeStrategy).kbase(this.kbase).ksession(this.ksession).mergeMode(this.mergeMode).pollInterval(this.pollInterval).scannerStatus(this.scannerStatus);
        ContainerSpec containerSpec = containerBuilder.build(this.templateId, this.templateName);
        LogHelper.logContainer(this.getLog(), containerSpec);
        this.container = containerBuilder.getId();
        this.kieControllerGateway.createContainer(this.templateId, containerSpec);
        this.getLog().info((CharSequence)("Container " + this.container + " CREATED on server template " + this.templateId));
    }
}

