/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.builder;

import java.util.HashMap;
import org.hibernate.validator.constraints.NotEmpty;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;

public class ContainerBuilder {
    private String id;
    @NotEmpty
    private String groupId;
    @NotEmpty
    private String artifactId;
    @NotEmpty
    private String version;
    private String runtimeStrategy;
    private String kbase;
    private String ksession;
    private String mergeMode;
    private Long pollInterval;
    private String scannerStatus;

    public String getId() {
        return this.id != null ? this.id : this.getGAV();
    }

    public ContainerSpec build(String templateId, String templateName) {
        HashMap<Capability, Object> configs = new HashMap<Capability, Object>();
        if (this.runtimeStrategy != null || this.kbase != null || this.ksession != null || this.mergeMode != null) {
            ProcessConfig processConfig = new ProcessConfig();
            configs.put(Capability.PROCESS, processConfig);
            processConfig.setRuntimeStrategy(this.runtimeStrategy);
            processConfig.setKBase(this.kbase);
            processConfig.setKSession(this.ksession);
            processConfig.setMergeMode(this.mergeMode);
        }
        if (this.pollInterval != null || this.scannerStatus != null) {
            RuleConfig ruleConfig = new RuleConfig();
            configs.put(Capability.RULE, ruleConfig);
            ruleConfig.setPollInterval(this.pollInterval);
            KieScannerStatus kieScannerStatus = KieScannerStatus.valueOf((String)this.scannerStatus);
            ruleConfig.setScannerStatus(kieScannerStatus);
        }
        ReleaseId releasedId = new ReleaseId(this.groupId, this.artifactId, this.version);
        return new ContainerSpec(this.getId(), this.getId(), new ServerTemplateKey(templateId, templateName), releasedId, KieContainerStatus.STOPPED, configs);
    }

    private String getGAV() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public static ContainerBuilder create(String groupId, String artifactId, String version) {
        ContainerBuilder containerBuilder = new ContainerBuilder();
        containerBuilder.setGroupId(groupId);
        containerBuilder.setArtifactId(artifactId);
        containerBuilder.setVersion(version);
        return containerBuilder;
    }

    public ContainerBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ContainerBuilder runtimeStrategy(String runtimeStrategy) {
        this.runtimeStrategy = runtimeStrategy;
        return this;
    }

    public ContainerBuilder kbase(String kbase) {
        this.kbase = kbase;
        return this;
    }

    public ContainerBuilder ksession(String ksession) {
        this.ksession = ksession;
        return this;
    }

    public ContainerBuilder mergeMode(String mergeMode) {
        this.mergeMode = mergeMode;
        return this;
    }

    public ContainerBuilder pollInterval(Long pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public ContainerBuilder scannerStatus(String scannerStatus) {
        this.scannerStatus = scannerStatus;
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRuntimeStrategy(String runtimeStrategy) {
        this.runtimeStrategy = runtimeStrategy;
    }

    public void setKbase(String kbase) {
        this.kbase = kbase;
    }

    public void setKsession(String ksession) {
        this.ksession = ksession;
    }

    public void setMergeMode(String mergeMode) {
        this.mergeMode = mergeMode;
    }

    public void setPollInterval(Long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setScannerStatus(String scannerStatus) {
        this.scannerStatus = scannerStatus;
    }
}

