/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.gateway.Authenticator;
import org.kie.server.gateway.ErrorResponseFilter;

public class KieControllerGateway {
    private final ResteasyClient client;
    private final String targetUrl;
    private final JSONMarshaller jsonMarshaller;

    public KieControllerGateway(String protocol, String hostname, Integer port, String username, String password, Integer connectionTimeout, Integer socketTimeout, String contextPath, String controllerPath) {
        this.targetUrl = protocol + "://" + hostname + ":" + port + "/" + contextPath + controllerPath;
        this.client = new ResteasyClientBuilder().connectionPoolSize(1).establishConnectionTimeout((long)connectionTimeout.intValue(), TimeUnit.SECONDS).socketTimeout((long)socketTimeout.intValue(), TimeUnit.SECONDS).register((Object)new Authenticator(username, password)).register((Object)new ErrorResponseFilter()).build();
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(ProcessConfig.class);
        classes.add(RuleConfig.class);
        this.jsonMarshaller = new JSONMarshaller(classes, Thread.currentThread().getContextClassLoader());
    }

    public ServerTemplateList getServerTemplateList() {
        String response = (String)this.client.target(this.targetUrl).path("management").path("servers").request(new String[]{"application/json"}).get(String.class);
        return (ServerTemplateList)this.jsonMarshaller.unmarshall(response, ServerTemplateList.class);
    }

    public ServerTemplate getServerTemplate(String templateId) {
        String response = (String)this.client.target(this.targetUrl).path("management").path("servers").path(templateId).request(new String[]{"application/json"}).get(String.class);
        return (ServerTemplate)this.jsonMarshaller.unmarshall(response, ServerTemplate.class);
    }

    public void createServerTemplate(ServerTemplate serverTemplate) {
        String payload = this.jsonMarshaller.marshall((Object)serverTemplate);
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(serverTemplate.getId()).request(new String[]{"application/json"}).put(Entity.json((Object)payload));
        response.close();
    }

    public void deleteServerTemplate(String templateId) {
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(templateId).request(new String[]{"application/json"}).delete();
        response.close();
    }

    public ContainerSpecList getContainers(String templateId) {
        String response = (String)this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").request(new String[]{"application/json"}).get(String.class);
        return (ContainerSpecList)this.jsonMarshaller.unmarshall(response, ContainerSpecList.class);
    }

    public ContainerSpec getContainer(String templateId, String containerId) {
        String response = (String)this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").path(containerId).request(new String[]{"application/json"}).get(String.class);
        return (ContainerSpec)this.jsonMarshaller.unmarshall(response, ContainerSpec.class);
    }

    public void createContainer(String templateId, String containerId, ContainerSpec containerSpec) {
        String payload = this.jsonMarshaller.marshall((Object)containerSpec);
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").path(containerId).request(new String[]{"application/json"}).put(Entity.json((Object)payload));
        response.close();
    }

    public void disposeContainer(String templateId, String containerId) {
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").path(containerId).request(new String[]{"application/json"}).delete();
        response.close();
    }

    public void startContainer(String templateId, String containerId) {
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").path(containerId).path("status").path("started").request(new String[]{"application/json"}).post(Entity.entity(null, (String)"application/json"));
        response.close();
    }

    public void stopContainer(String templateId, String containerId) {
        Response response = this.client.target(this.targetUrl).path("management").path("servers").path(templateId).path("containers").path(containerId).path("status").path("stopped").request(new String[]{"application/json"}).post(Entity.entity(null, (String)"application/json"));
        response.close();
    }

    public void close() {
        this.client.close();
        this.jsonMarshaller.dispose();
    }
}

