/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.gateway.Authenticator;
import org.kie.server.gateway.ErrorResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerGateway {
    private static final Logger LOG = LoggerFactory.getLogger(KieServerGateway.class);
    private final ResteasyClient client;

    public KieServerGateway(String username, String password, Integer connectionTimeout, Integer socketTimeout) {
        this.client = new ResteasyClientBuilder().connectionPoolSize(1).establishConnectionTimeout((long)connectionTimeout.intValue(), TimeUnit.SECONDS).socketTimeout((long)socketTimeout.intValue(), TimeUnit.SECONDS).register((Object)new Authenticator(username, password)).register((Object)new ErrorResponseFilter()).build();
    }

    public KieContainerResource getContainer(String serverUrl, String container) {
        ServiceResponse response = (ServiceResponse)this.client.target(serverUrl).path("containers").path(container).request(new String[]{"application/json"}).get(ServiceResponse.class);
        return (KieContainerResource)response.getResult();
    }

    public void close() {
        this.client.close();
    }
}

