/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import javax.ws.rs.ProcessingException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.kie.server.gateway.KieControllerGateway;

public abstract class KieControllerMojo
extends AbstractMojo {
    @Parameter(property="kie-ctrl.hostname", defaultValue="localhost")
    private String hostname;
    @Parameter(property="kie-ctrl.port", defaultValue="8080")
    private Integer port;
    @Parameter(property="kie-ctrl.protocol", defaultValue="http")
    private String protocol;
    @Parameter(property="kie-ctrl.context-path", defaultValue="business-central")
    private String contextPath;
    @Parameter(property="kie-ctrl.controller-path", defaultValue="/rest/controller")
    private String controllerPath;
    @Parameter(property="kie-ctrl.controller-username", required=true, readonly=true)
    private String controllerUsername;
    @Parameter(property="kie-ctrl.controller-password", required=true, readonly=true)
    private String controllerPassword;
    @Parameter(property="kie-ctrl.connection-timeout", defaultValue="100")
    protected Integer connectionTimeout;
    @Parameter(property="kie-ctrl.socket-timeout", defaultValue="2")
    protected Integer socketTimeout;
    protected KieControllerGateway kieControllerGateway;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Protocol: " + this.protocol));
        this.getLog().info((CharSequence)("Host Name: " + this.hostname));
        this.getLog().info((CharSequence)("Port: " + this.port));
        this.getLog().info((CharSequence)("Controller Username: " + this.controllerUsername));
        this.getLog().debug((CharSequence)"Controller Password: ###SECRET###");
        this.getLog().debug((CharSequence)("Connection Timeout: " + this.connectionTimeout));
        this.getLog().debug((CharSequence)("Socket Timeout: " + this.socketTimeout));
        this.getLog().debug((CharSequence)("Context Path: " + this.contextPath));
        this.kieControllerGateway = new KieControllerGateway(this.protocol, this.hostname, this.port, this.controllerUsername, this.controllerPassword, this.connectionTimeout, this.socketTimeout, this.contextPath, this.controllerPath);
        try {
            this.executeCommand();
        }
        catch (ProcessingException pe) {
            throw new MojoFailureException(pe.getMessage(), (Throwable)pe);
        }
        finally {
            this.kieControllerGateway.close();
        }
    }

    public abstract void executeCommand() throws MojoExecutionException, MojoFailureException;
}

