/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;

@Mojo(name="get-containers", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=false)
public class GetContainersMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=true)
    protected String templateId;

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        ContainerSpecList containers = this.kieControllerGateway.getContainers(this.templateId);
        LogHelper.logContainers(this.getLog(), Arrays.asList(containers.getContainerSpecs()));
    }
}

