/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class ErrorResponseFilter
implements ClientResponseFilter {
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Response.Status status = Response.Status.fromStatusCode((int)responseContext.getStatus());
        if (Response.Status.NOT_FOUND.equals((Object)status) && responseContext.hasEntity()) {
            String errorMessage = IOUtils.toString((InputStream)responseContext.getEntityStream(), (String)"UTF-8");
            throw new NotFoundException(errorMessage);
        }
        if (Response.Status.INTERNAL_SERVER_ERROR.equals((Object)status) && requestContext.hasEntity()) {
            String errorMessage = IOUtils.toString((InputStream)responseContext.getEntityStream(), (String)"UTF-8");
            throw new ServerErrorException(errorMessage, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (responseContext.getStatus() < 200 || responseContext.getStatus() >= 300) {
            if (requestContext.hasEntity()) {
                String errorMessage = IOUtils.toString((InputStream)responseContext.getEntityStream(), (String)"UTF-8");
                throw new WebApplicationException(errorMessage, status);
            }
            throw new WebApplicationException(status);
        }
    }
}

