/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Configuration;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.KieServerControllerClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieControllerGateway {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieControllerGateway.class);
    private final KieServerControllerClient client;
    private final String targetUrl;

    public KieControllerGateway(String protocol, String hostname, Integer port, String username, String password, Integer connectionTimeout, Integer socketTimeout, String contextPath, String controllerPath) {
        this.targetUrl = protocol + "://" + hostname + ":" + port + "/" + contextPath + controllerPath;
        Configuration configuration = new ResteasyClientBuilder().connectionPoolSize(1).establishConnectionTimeout((long)connectionTimeout.intValue(), TimeUnit.SECONDS).socketTimeout((long)socketTimeout.intValue(), TimeUnit.SECONDS).getConfiguration();
        this.client = KieServerControllerClientFactory.newRestClient((String)this.targetUrl, (String)username, (String)password, (MarshallingFormat)MarshallingFormat.JSON, (Configuration)configuration);
    }

    public ServerTemplateList getServerTemplateList() {
        return this.client.listServerTemplates();
    }

    public ServerTemplate getServerTemplate(String templateId) {
        return this.client.getServerTemplate(templateId);
    }

    public void createServerTemplate(ServerTemplate serverTemplate) {
        this.client.saveServerTemplate(serverTemplate);
    }

    public void deleteServerTemplate(String templateId) {
        this.client.deleteServerTemplate(templateId);
    }

    public ContainerSpecList getContainers(String templateId) {
        return this.client.listContainerSpec(templateId);
    }

    public ContainerSpec getContainer(String templateId, String containerId) {
        return this.client.getContainerInfo(templateId, containerId);
    }

    public void createContainer(String templateId, ContainerSpec containerSpec) {
        this.client.saveContainerSpec(templateId, containerSpec);
    }

    public void disposeContainer(String templateId, String containerId) {
        this.client.deleteContainerSpec(templateId, containerId);
    }

    public void startContainer(String templateId, String containerId) {
        this.client.startContainer(new ContainerSpecKey(containerId, containerId, new ServerTemplateKey(templateId, templateId)));
    }

    public void stopContainer(String templateId, String containerId) {
        this.client.stopContainer(new ContainerSpecKey(containerId, containerId, new ServerTemplateKey(templateId, templateId)));
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to close Kie Server Controller Client due to: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

