/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.gateway;

import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.kie.server.api.marshalling.json.JSONMarshaller;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.common.rest.Authenticator;
import org.kie.server.gateway.ErrorResponseFilter;

public class KieServerGateway {
    private final ResteasyClient client;
    private final JSONMarshaller jsonMarshaller;

    public KieServerGateway(String username, String password, Integer connectionTimeout, Integer socketTimeout) {
        this.client = new ResteasyClientBuilder().connectionPoolSize(1).establishConnectionTimeout((long)connectionTimeout.intValue(), TimeUnit.SECONDS).socketTimeout((long)socketTimeout.intValue(), TimeUnit.SECONDS).register((Object)new Authenticator(username, password)).register((Object)new ErrorResponseFilter()).build();
        this.jsonMarshaller = new JSONMarshaller(null, Thread.currentThread().getContextClassLoader());
    }

    public KieContainerResource getContainer(String serverUrl, String container) {
        String response = (String)this.client.target(serverUrl).path("containers").path(container).request(new String[]{"application/json"}).get(String.class);
        ServiceResponse result = (ServiceResponse)this.jsonMarshaller.unmarshall(response, ServiceResponse.class);
        return (KieContainerResource)result.getResult();
    }

    public void close() {
        this.client.close();
    }
}

