/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.plugin.KieControllerMojo;

@Mojo(name="dispose-container", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=false)
public class DisposeContainerMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=true)
    protected String templateId;
    @Parameter(property="kie-ctrl.container")
    protected String container;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        ContainerSpec containerSpec;
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        if (this.container == null && this.project == null) {
            throw new MojoFailureException("Unable to find container name");
        }
        if (this.container == null) {
            this.container = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion();
        }
        try {
            containerSpec = this.kieControllerGateway.getContainer(this.templateId, this.container);
        }
        catch (NotFoundException containerNotFoundException) {
            this.getLog().info((CharSequence)("Container " + this.container + " not found on server template " + this.templateId + ". Skip that task"));
            return;
        }
        catch (ResponseProcessingException exception) {
            if (exception.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                this.getLog().info((CharSequence)("Container " + this.container + " not found on server template " + this.templateId + ". Skip that task"));
                return;
            }
            throw new RuntimeException(exception.getMessage(), exception);
        }
        if (KieContainerStatus.STARTED.equals((Object)containerSpec.getStatus())) {
            this.kieControllerGateway.stopContainer(this.templateId, this.container);
            this.getLog().info((CharSequence)("Container " + this.container + " STOPPED on server template " + this.templateId));
        }
        this.kieControllerGateway.disposeContainer(this.templateId, this.container);
        this.getLog().info((CharSequence)("Container " + this.container + " DISPOSED on server template " + this.templateId));
    }
}

