/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;

@Mojo(name="get-template", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=false)
public class GetTemplateMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=false)
    protected String templateId;

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        if (this.templateId != null) {
            this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
            ServerTemplate serverTemplate = this.kieControllerGateway.getServerTemplate(this.templateId);
            LogHelper.logServerTemplate(this.getLog(), serverTemplate);
            return;
        }
        ServerTemplateList serverTemplateList = this.kieControllerGateway.getServerTemplateList();
        for (ServerTemplate serverTemplate : serverTemplateList.getServerTemplates()) {
            LogHelper.logServerTemplate(this.getLog(), serverTemplate);
        }
    }
}

