/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.builder.ContainerBuilder;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;
import org.kie.server.controller.validate.NotDuplicateValidStrings;
import org.kie.server.controller.validate.ViolationHelper;

@Mojo(name="create-template", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=false)
public class CreateTemplateMojo
extends KieControllerMojo {
    public static final String[] TEMPLATE_CAPABILITIES = new String[]{"RULE", "PROCESS", "PLANNING"};
    @Parameter(property="kie-ctrl.template-id", required=true)
    private String templateId;
    @Parameter(property="kie-ctrl.template-name")
    private String templateName;
    @NotDuplicateValidStrings(admittedValues={"RULE", "PROCESS", "PLANNING"}, message="Capabilities not valid")
    @Parameter(property="kie-ctrl.capabilities")
    private List<String> capabilities;
    @Valid
    @Parameter(property="kie-ctrl.containers")
    private List<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        if (this.templateName == null || this.templateName.isEmpty()) {
            this.templateName = this.templateId;
        }
        if (this.capabilities == null) {
            this.capabilities = Arrays.asList(TEMPLATE_CAPABILITIES);
        }
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        this.getLog().info((CharSequence)("Server Template Name: " + this.templateName));
        this.getLog().info((CharSequence)("Capabilities: " + this.capabilities));
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this, new Class[0]);
        if (!violations.isEmpty()) {
            throw new MojoExecutionException(ViolationHelper.printViolations(violations));
        }
        ServerTemplate serverTemplate = new ServerTemplate();
        serverTemplate.setId(this.templateId);
        serverTemplate.setName(this.templateName);
        serverTemplate.setCapabilities(this.capabilities);
        List<ContainerSpec> containerSpecs = this.containers.stream().map(containerBuilder -> containerBuilder.build(this.templateId, this.templateName)).collect(Collectors.toList());
        LogHelper.logContainers(this.getLog(), containerSpecs);
        serverTemplate.setContainersSpec(containerSpecs);
        this.kieControllerGateway.createServerTemplate(serverTemplate);
        this.getLog().info((CharSequence)("Server template " + this.templateId + " CREATED"));
    }
}

