/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.validate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.kie.server.controller.validate.NotDuplicateValidStrings;

public class NotDuplicateValidStringsValidator
implements ConstraintValidator<NotDuplicateValidStrings, List<String>> {
    private Set<String> possibleValues;

    public void initialize(NotDuplicateValidStrings constraintAnnotation) {
        this.possibleValues = new HashSet<String>(Arrays.asList(constraintAnnotation.admittedValues()));
    }

    public boolean isValid(List<String> values, ConstraintValidatorContext context) {
        if (values == null) {
            return true;
        }
        if (values.isEmpty()) {
            return false;
        }
        HashSet<String> oldValues = new HashSet<String>();
        for (String value : values) {
            if (value == null) {
                return false;
            }
            if (oldValues.contains(value)) {
                return false;
            }
            if (!this.possibleValues.contains(value)) {
                return false;
            }
            oldValues.add(value);
        }
        return true;
    }
}

